/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.shadowmage.ancientwarfare.core.util.AWTextureManager;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import org.lwjgl.opengl.GL11;

public class RenderNpcBase
extends RenderBiped {
    List<Integer> renderTasks = new ArrayList<Integer>();

    public RenderNpcBase() {
        super(new ModelBiped(), 0.6f);
    }

    public void func_76986_a(Entity par1Entity, double x, double y, double z, float par8, float par9) {
        super.func_76986_a(par1Entity, x, y, z, par8, par9);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        NpcBase npc = (NpcBase)par1Entity;
        if (npc.isHostileTowards((Entity)player)) {
            if (AWNPCStatics.renderHostileNames.getBoolean()) {
                String name = this.getNameForRender(npc, true);
                if (AWNPCStatics.renderTeamColors.getBoolean()) {
                    ScorePlayerTeam playerTeam = player.field_70170_p.func_96441_U().func_96508_e(player.func_70005_c_());
                    ScorePlayerTeam npcTeam = (ScorePlayerTeam)npc.func_96124_cp();
                    if (npcTeam != null && npcTeam != playerTeam) {
                        name = npcTeam.func_96668_e() + name + npcTeam.func_96663_f();
                    }
                }
                this.renderColoredLabel(npc, name, x, y, z, 64, 0x20FF0000, -65536);
            }
        } else {
            boolean canBeCommandedBy = npc.canBeCommandedBy(player.func_70005_c_());
            if (AWNPCStatics.renderFriendlyNames.getBoolean()) {
                String name = this.getNameForRender(npc, false);
                if (AWNPCStatics.renderTeamColors.getBoolean()) {
                    ScorePlayerTeam playerTeam = player.field_70170_p.func_96441_U().func_96508_e(player.func_70005_c_());
                    ScorePlayerTeam npcTeam = (ScorePlayerTeam)npc.func_96124_cp();
                    if (npcTeam != null && npcTeam != playerTeam) {
                        name = npcTeam.func_96668_e() + name + npcTeam.func_96663_f();
                    }
                } else if (!canBeCommandedBy) {
                    name = EnumChatFormatting.DARK_GRAY.toString() + name;
                }
                this.renderColoredLabel(npc, name, x, y, z, 64, 0x20FFFFFF, -1);
            }
            if (canBeCommandedBy && AWNPCStatics.renderAI.getBoolean()) {
                this.renderNpcAITasks(npc, x, y, z, 64);
            }
        }
    }

    protected void func_82420_a(EntityLiving par1EntityLiving, ItemStack par2ItemStack) {
        super.func_82420_a(par1EntityLiving, par2ItemStack);
        NpcBase npc = (NpcBase)par1EntityLiving;
        this.field_77071_a.field_78119_l = npc.getShieldStack() != null ? 1 : 0;
        this.field_82425_h.field_78119_l = this.field_77071_a.field_78119_l;
        this.field_82423_g.field_78119_l = this.field_77071_a.field_78119_l;
    }

    protected void func_77029_c(EntityLiving par1EntityLiving, float par2) {
        super.func_77029_c(par1EntityLiving, par2);
        NpcBase npc = (NpcBase)par1EntityLiving;
        ItemStack itemstack = npc.getShieldStack();
        if (itemstack != null && itemstack.func_77973_b() != null) {
            boolean is3D;
            float f1;
            Item item = itemstack.func_77973_b();
            GL11.glPushMatrix();
            if (this.field_77045_g.field_78091_s) {
                f1 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.625f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)f1, (float)f1, (float)f1);
            }
            this.field_77071_a.field_78113_g.func_78794_c(0.0625f);
            GL11.glTranslatef((float)0.0f, (float)0.5625f, (float)0.0f);
            IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED);
            boolean bl = is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D);
            if (item instanceof ItemBlock && (is3D || RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item).func_149645_b()))) {
                f1 = 0.5f;
                GL11.glTranslatef((float)0.0625f, (float)0.0625f, (float)-0.25f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(-(f1 *= 0.75f)), (float)(-f1), (float)f1);
            } else if (item == Items.field_151031_f) {
                f1 = 0.625f;
                GL11.glTranslatef((float)0.125f, (float)0.0f, (float)0.375f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (item.func_77662_d()) {
                f1 = 0.625f;
                if (item.func_77629_n_()) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
                }
                GL11.glTranslatef((float)0.125f, (float)0.0625f, (float)0.0625f);
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                f1 = 0.375f;
                GL11.glTranslatef((float)0.1875f, (float)0.0f, (float)-0.0625f);
                GL11.glScalef((float)f1, (float)f1, (float)f1);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (itemstack.func_77973_b().func_77623_v()) {
                for (int i = 0; i < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++i) {
                    int j = itemstack.func_77973_b().func_82790_a(itemstack, i);
                    float f2 = (float)(j >> 16 & 0xFF) / 255.0f;
                    float f3 = (float)(j >> 8 & 0xFF) / 255.0f;
                    float f4 = (float)(j & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f2, (float)f3, (float)f4, (float)1.0f);
                    this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)par1EntityLiving, itemstack, i);
                }
            } else {
                int i = itemstack.func_77973_b().func_82790_a(itemstack, 0);
                float f5 = (float)(i >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(i & 0xFF) / 255.0f;
                GL11.glColor4f((float)f5, (float)f2, (float)f3, (float)1.0f);
                this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)par1EntityLiving, itemstack, 0);
            }
            GL11.glPopMatrix();
        }
    }

    protected boolean func_110813_b(EntityLivingBase par1EntityLivingBase) {
        return false;
    }

    protected void func_147906_a(Entity p_147906_1_, String p_147906_2_, double p_147906_3_, double p_147906_5_, double p_147906_7_, int p_147906_9_) {
    }

    private String getNameForRender(NpcBase npc, boolean hostile) {
        boolean addHealth;
        String customName = npc.func_94056_bM() ? npc.func_94057_bL() : npc.func_70005_c_();
        boolean bl = addHealth = hostile && AWNPCStatics.renderHostileHealth.getBoolean() || !hostile && AWNPCStatics.renderFriendlyHealth.getBoolean();
        if (addHealth) {
            customName = customName + " " + this.getHealthForRender(npc);
        }
        return customName;
    }

    private String getHealthForRender(NpcBase npc) {
        return String.format("%.1f", Float.valueOf(npc.func_110143_aJ()));
    }

    private void renderNpcAITasks(NpcBase entity, double x, double y, double z, int renderDistance) {
        double d3 = entity.func_70068_e((Entity)this.field_76990_c.field_78734_h);
        if (d3 <= (double)(renderDistance * renderDistance) && this.field_76990_c.field_78734_h.func_70685_l((Entity)entity)) {
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + entity.field_70131_O + 0.5f), (float)((float)z));
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tasks = entity.getAITasks();
            for (int i = 0; i < 10; ++i) {
                int mask = 1 << i;
                if ((tasks & mask) == 0) continue;
                this.renderTasks.add(mask);
            }
            int offset = this.renderTasks.size() * 10 / 2;
            int startX = -offset;
            for (int i = 0; i < this.renderTasks.size(); ++i) {
                String icon = this.getIconFor(this.renderTasks.get(i));
                this.renderIcon(icon, 16, 16, startX + i * 20, -16);
            }
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            this.renderTasks.clear();
        }
    }

    private void renderColoredLabel(NpcBase entity, String string, double x, double y, double z, int renderDistance, int color1, int color2) {
        double d3 = entity.func_70068_e((Entity)this.field_76990_c.field_78734_h);
        if (d3 <= (double)(renderDistance * renderDistance) && this.field_76990_c.field_78734_h.func_70685_l((Entity)entity)) {
            FontRenderer fontrenderer = this.func_76983_a();
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + entity.field_70131_O + 0.5f), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int j = fontrenderer.func_78256_a(string) / 2;
            tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
            tessellator.func_78377_a((double)(-j - 1), -1.0, 0.0);
            tessellator.func_78377_a((double)(-j - 1), 8.0, 0.0);
            tessellator.func_78377_a((double)(j + 1), 8.0, 0.0);
            tessellator.func_78377_a((double)(j + 1), -1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fontrenderer.func_78276_b(string, -fontrenderer.func_78256_a(string) / 2, 0, color1);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            fontrenderer.func_78276_b(string, -fontrenderer.func_78256_a(string) / 2, 0, color2);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    protected ResourceLocation func_110775_a(Entity par1Entity) {
        return ((NpcBase)par1Entity).getTexture();
    }

    private void renderIcon(String tex, int width, int height, int x, int y) {
        Tessellator tess = Tessellator.field_78398_a;
        AWTextureManager.instance().bindLocationTexture(tex);
        int halfW = width / 2;
        int halfH = height / 2;
        tess.func_78382_b();
        tess.func_78374_a((double)(x - halfW), (double)(y - halfH), 0.0, 0.0, 0.0);
        tess.func_78374_a((double)(x - halfW), (double)(y + halfH), 0.0, 0.0, 1.0);
        tess.func_78374_a((double)(x + halfW), (double)(y + halfH), 0.0, 1.0, 1.0);
        tess.func_78374_a((double)(x + halfW), (double)(y + -halfH), 0.0, 1.0, 0.0);
        tess.func_78381_a();
    }

    private String getIconFor(int task) {
        switch (task) {
            case 0: {
                return null;
            }
            case 1: {
                return "ancientwarfare:textures/entity/npc/ai/task_attack.png";
            }
            case 2: {
                return "ancientwarfare:textures/entity/npc/ai/task_upkeep.png";
            }
            case 4: {
                return "ancientwarfare:textures/entity/npc/ai/task_upkeep2.png";
            }
            case 8: {
                return "ancientwarfare:textures/entity/npc/ai/task_home.png";
            }
            case 16: {
                return "ancientwarfare:textures/entity/npc/ai/task_work.png";
            }
            case 32: {
                return "ancientwarfare:textures/entity/npc/ai/task_patrol.png";
            }
            case 64: {
                return "ancientwarfare:textures/entity/npc/ai/task_guard.png";
            }
            case 128: {
                return "ancientwarfare:textures/entity/npc/ai/task_follow.png";
            }
            case 256: {
                return "ancientwarfare:textures/entity/npc/ai/task_wander.png";
            }
            case 512: {
                return "ancientwarfare:textures/entity/npc/ai/task_move.png";
            }
        }
        return null;
    }
}

