/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.skin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcSkinManager {
    public static final NpcSkinManager INSTANCE = new NpcSkinManager();
    private final HashMap<String, SkinGroup> skinGroups = new HashMap();
    private final Random rng = new Random();
    private final String skinMainPath = "config/ancientwarfare/npc/skins/";
    private static final String defaultSkinPack = "/assets/ancientwarfare/skin_pack/default_skin_pack.zip";

    public ResourceLocation getTextureFor(NpcBase npc) {
        ResourceLocation loc = null;
        long id = npc.getIDForSkin();
        if (!npc.getCustomTex().isEmpty()) {
            loc = this.getNpcTexture(npc.getCustomTex(), id);
        }
        if (loc == null) {
            loc = this.getNpcTexture(npc.getNpcFullType(), id);
        }
        return loc;
    }

    private ResourceLocation getNpcTexture(String type, long idlsb) {
        SkinGroup group = this.skinGroups.get(type);
        if (group != null && !group.textures.isEmpty()) {
            this.rng.setSeed(idlsb);
            int tex = this.rng.nextInt(group.textures.size());
            return group.getTexture(tex);
        }
        return null;
    }

    public void loadSkinPacks() {
        if (AWNPCStatics.loadDefaultSkinPack) {
            this.loadDefaultSkinPack();
        }
        String path = "config/ancientwarfare/npc/skins/";
        File file = new File(path);
        file.mkdirs();
        ArrayList<File> probableZipFiles = new ArrayList<File>();
        this.recursiveScan(new File(path), probableZipFiles);
        this.parseZipFiles(probableZipFiles);
    }

    private void loadDefaultSkinPack() {
        InputStream is = this.getClass().getResourceAsStream(defaultSkinPack);
        ZipInputStream zis = new ZipInputStream(is);
        SkinPack pack = this.loadPackFromZip("default_skin_pack.zip", zis);
        if (pack != null) {
            this.unpackSkinPack(pack);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private SkinPack loadPackFromZip(String fileName, ZipInputStream zis) {
        HashMap<String, ResourceLocation> parsedImages = new HashMap<String, ResourceLocation>();
        SkinMeta metaFile = null;
        SkinPack pack = null;
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                ResourceLocation loc;
                if (entry.isDirectory()) continue;
                if (entry.getName().toLowerCase(Locale.ENGLISH).equals("skin_pack.meta")) {
                    metaFile = new SkinMeta(zis);
                    continue;
                }
                if (!entry.getName().toLowerCase(Locale.ENGLISH).endsWith(".png") || (loc = this.loadSkinPackImage(fileName, entry.getName(), zis)) == null) continue;
                parsedImages.put(entry.getName(), loc);
            }
            if (metaFile != null) {
                pack = new SkinPack(metaFile, parsedImages);
                AWLog.log("Loaded Skin pack: " + fileName + " containing: " + parsedImages.size() + " skins.");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            zis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pack;
    }

    private void recursiveScan(File directory, List<File> zipFileList) {
        if (directory == null) {
            AWLog.logError("Could not locate directory to load structures!");
            return;
        }
        File[] allFiles = directory.listFiles();
        if (allFiles == null) {
            AWLog.logError("Could not locate " + directory + " directory to load skin packs!--no files in directory file list!");
            return;
        }
        for (File currentFile : allFiles) {
            if (currentFile.isDirectory()) {
                this.recursiveScan(currentFile, zipFileList);
                continue;
            }
            if (!this.isProbableZip(currentFile)) continue;
            zipFileList.add(currentFile);
        }
    }

    private void parseZipFiles(List<File> probableZipFiles) {
        ArrayList<SkinPack> skinPacks = new ArrayList<SkinPack>();
        ZipInputStream zis = null;
        FileInputStream fis = null;
        for (File f : probableZipFiles) {
            try {
                fis = new FileInputStream(f);
                zis = new ZipInputStream(fis);
                SkinPack pack = this.loadPackFromZip(f.getName(), zis);
                if (pack != null) {
                    skinPacks.add(pack);
                }
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        this.unpackSkinPacks(skinPacks);
    }

    private void unpackSkinPacks(List<SkinPack> packs) {
        for (SkinPack pack : packs) {
            this.unpackSkinPack(pack);
        }
    }

    private void unpackSkinPack(SkinPack pack) {
        HashMap<String, Set<String>> map = pack.meta.imageMap;
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            for (String img : entry.getValue()) {
                if (!pack.textures.containsKey(img)) continue;
                this.loadSkinImage(entry.getKey(), pack.textures.get(img));
            }
        }
    }

    private void loadSkinImage(String npcType, ResourceLocation texture) {
        this.getOrCreateSkinGroup(npcType).addTexture(texture);
    }

    private SkinGroup getOrCreateSkinGroup(String npcType) {
        if (!this.skinGroups.containsKey(npcType)) {
            SkinGroup group = new SkinGroup();
            this.skinGroups.put(npcType, group);
            return group;
        }
        return this.skinGroups.get(npcType);
    }

    private ResourceLocation loadSkinPackImage(String packName, String imageName, InputStream is) {
        return AncientWarfareNPC.proxy.loadSkinPackImage(packName, imageName, is);
    }

    private boolean isProbableZip(File file) {
        return file.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip");
    }

    private class SkinMeta {
        final HashMap<String, Set<String>> imageMap = new HashMap();

        public SkinMeta(InputStream is) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while (br.ready()) {
                String line = br.readLine();
                String[] lineBits = line.split("=");
                if (lineBits.length <= 1) continue;
                if (!this.imageMap.containsKey(lineBits[0])) {
                    this.imageMap.put(lineBits[0], new HashSet());
                }
                this.imageMap.get(lineBits[0]).add(lineBits[1]);
            }
        }

        public String toString() {
            return "SkinPackMeta -- imageMap: [" + this.imageMap + "]";
        }
    }

    private class SkinPack {
        final SkinMeta meta;
        final HashMap<String, ResourceLocation> textures = new HashMap();

        public SkinPack(SkinMeta meta, Map<String, ResourceLocation> textureMap) {
            this.meta = meta;
            this.textures.putAll(textureMap);
        }
    }

    private class SkinGroup {
        final List<ResourceLocation> textures = new ArrayList<ResourceLocation>();

        private SkinGroup() {
        }

        public void addTexture(ResourceLocation loc) {
            this.textures.add(loc);
        }

        public ResourceLocation getTexture(int index) {
            return this.textures.get(index);
        }
    }
}

