/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.trade.Trade;

public class POTrade
extends Trade {
    private List<ItemStack> compactInput = new ArrayList<ItemStack>();
    private List<ItemStack> compactOutput = new ArrayList<ItemStack>();

    @Override
    public void setInputStack(int index, ItemStack stack) {
        super.setInputStack(index, stack);
        this.updateCompactInput();
    }

    @Override
    public void setOutputStack(int index, ItemStack stack) {
        super.setOutputStack(index, stack);
        this.updateCompactOutput();
    }

    private void updateCompactInput() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack temp : this.input) {
            if (temp == null) continue;
            list.add(temp.func_77946_l());
        }
        this.compactInput = InventoryTools.compactStackList3(list);
    }

    private void updateCompactOutput() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack temp : this.output) {
            if (temp == null) continue;
            list.add(temp.func_77946_l());
        }
        this.compactOutput = InventoryTools.compactStackList3(list);
    }

    public boolean isAvailable(IInventory storage) {
        for (ItemStack stack : this.compactOutput) {
            if (InventoryTools.getCountOf(storage, -1, stack) >= stack.field_77994_a) continue;
            return false;
        }
        return InventoryTools.canInventoryHold(storage, -1, this.compactInput);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.updateCompactInput();
        this.updateCompactOutput();
    }
}

