/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.trade.POTradeTransferEntry;

public final class POTradeDepositEntry
extends POTradeTransferEntry {
    @Override
    public POTradeTransferEntry.TransferType getDefaultType() {
        return POTradeDepositType.ALL_OF;
    }

    @Override
    public void toggleType() {
        int o = this.getType().ordinal();
        if (++o >= POTradeDepositType.values().length) {
            o = 0;
        }
        this.setType(POTradeDepositType.values()[o]);
    }

    @Override
    protected POTradeTransferEntry.TransferType getTypeFrom(int type) {
        return POTradeDepositType.values()[type];
    }

    public static enum POTradeDepositType implements POTradeTransferEntry.TransferType
    {
        ALL_OF{

            @Override
            public void doTransfer(IInventory storage, IInventory move, int side, ItemStack filter) {
                int count = InventoryTools.getCountOf(storage, -1, filter);
                if (count > 0) {
                    InventoryTools.transferItems(storage, move, filter, count, -1, side);
                }
            }
        }
        ,
        QUANTITY{

            @Override
            public void doTransfer(IInventory storage, IInventory move, int side, ItemStack filter) {
                int count = InventoryTools.getCountOf(storage, -1, filter);
                if (count > filter.field_77994_a) {
                    count = filter.field_77994_a;
                }
                InventoryTools.transferItems(storage, move, filter, count, -1, side);
            }
        }
        ,
        DEPOSIT_EXCESS{

            @Override
            public void doTransfer(IInventory storage, IInventory move, int side, ItemStack filter) {
                int count = InventoryTools.getCountOf(storage, -1, filter);
                if (count > filter.field_77994_a) {
                    InventoryTools.transferItems(storage, move, filter, count - filter.field_77994_a, -1, side);
                }
            }
        };

    }
}

