/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.Json;
import net.shadowmage.ancientwarfare.core.util.JsonTagReader;
import net.shadowmage.ancientwarfare.core.util.JsonTagWriter;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.NBTTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateParsingException;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuildingException;

public abstract class TemplateRule {
    public int ruleNumber = -1;

    public abstract void handlePlacement(World var1, int var2, int var3, int var4, int var5, IStructureBuilder var6) throws StructureBuildingException;

    public abstract void parseRuleData(NBTTagCompound var1);

    public abstract void writeRuleData(NBTTagCompound var1);

    public abstract void addResources(List<ItemStack> var1);

    public abstract boolean shouldPlaceOnBuildPass(World var1, int var2, int var3, int var4, int var5, int var6);

    public void writeRule(BufferedWriter out) throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeRuleData(tag);
        this.writeTag(out, tag);
    }

    public void parseRule(int ruleNumber, List<String> lines) throws TemplateParsingException.TemplateRuleParsingException {
        this.ruleNumber = ruleNumber;
        NBTTagCompound tag = this.readTag(lines);
        this.parseRuleData(tag);
    }

    public final void writeTag(BufferedWriter out, NBTTagCompound tag) throws IOException {
        String line = Json.getJsonData(JsonTagWriter.getJsonForTag(tag));
        out.write(line);
        out.newLine();
    }

    public final NBTTagCompound readTag(List<String> ruleData) throws TemplateParsingException.TemplateRuleParsingException {
        String line2;
        for (String line2 : ruleData) {
            if (!line2.startsWith("JSON:{")) continue;
            return JsonTagReader.parseTagCompound(line2);
        }
        for (String line2 : ruleData) {
            if (!line2.toLowerCase(Locale.ENGLISH).startsWith("jsontag=")) continue;
            try {
                NBTBase tag = JsonToNBT.func_150315_a((String)line2.split("=", -1)[1]);
                if (!(tag instanceof NBTTagCompound)) continue;
                return (NBTTagCompound)tag;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TemplateParsingException.TemplateRuleParsingException("Caught exception while parsing json-nbt tag: " + line2, e);
            }
        }
        ArrayList<String> tagLines = new ArrayList<String>();
        Iterator<String> it = ruleData.iterator();
        block4: while (it.hasNext() && (line2 = it.next()) != null) {
            if (!line2.startsWith("tag:")) continue;
            it.remove();
            while (it.hasNext() && (line2 = it.next()) != null) {
                it.remove();
                if (line2.startsWith(":endtag")) continue block4;
                tagLines.add(line2);
            }
        }
        return NBTTools.readNBTFrom(tagLines);
    }

    public String toString() {
        return "Template rule: " + this.ruleNumber + " type: " + this.getClass().getSimpleName();
    }
}

