/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.structure.item.AWStructuresItemLoader;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class BlockAdvancedSpawner
extends Block {
    IIcon transparentIcon;

    public BlockAdvancedSpawner() {
        super(Material.field_151576_e);
        this.func_149647_a(AWStructuresItemLoader.structureTab);
        this.func_149658_d("ancientwarfare:structure/advanced_spawner");
        this.func_149711_c(2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileAdvancedSpawner spawner;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileAdvancedSpawner && (spawner = (TileAdvancedSpawner)te).getSettings().isTransparent()) {
            return this.transparentIcon;
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB maskBB, List list, Entity entity) {
        if (world.field_72996_f.contains(entity)) {
            super.func_149743_a(world, x, y, z, maskBB, list, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        super.func_149651_a(p_149651_1_);
        this.transparentIcon = p_149651_1_.func_94245_a("ancientwarfare:structure/advanced_spawner2");
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileAdvancedSpawner();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && te instanceof TileAdvancedSpawner) {
            TileAdvancedSpawner spawner = (TileAdvancedSpawner)te;
            spawner.onBlockBroken();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileAdvancedSpawner) {
            TileAdvancedSpawner spawner = (TileAdvancedSpawner)te;
            return spawner.getBlockHardness();
        }
        return super.func_149712_f(world, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileAdvancedSpawner) {
            ItemStack item = new ItemStack((Block)this);
            NBTTagCompound settings = new NBTTagCompound();
            ((TileAdvancedSpawner)te).getSettings().writeToNBT(settings);
            item.func_77983_a("spawnerSettings", (NBTBase)settings);
            return item;
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int sideHit, float hitX, float hitY, float hitZ) {
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                if (player.func_70093_af()) {
                    NetworkHandler.INSTANCE.openGui(player, 10, x, y, z);
                } else {
                    NetworkHandler.INSTANCE.openGui(player, 8, x, y, z);
                }
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, sideHit, hitX, hitY, hitZ);
    }
}

