/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;

public class ContainerSoundBlock
extends ContainerTileBase<TileSoundBlock> {
    public SongPlayData data;
    public boolean redstoneInteraction;
    public int range;

    public ContainerSoundBlock(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.data = ((TileSoundBlock)this.tileEntity).getSongs();
        this.redstoneInteraction = ((TileSoundBlock)this.tileEntity).isRedstoneInteraction();
        this.range = ((TileSoundBlock)this.tileEntity).getPlayerRange();
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tuneData", (NBTBase)this.data.writeToNBT(new NBTTagCompound()));
        tag.func_74757_a("redstone", this.redstoneInteraction);
        tag.func_74768_a("range", this.range);
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("tuneData")) {
            ((TileSoundBlock)this.tileEntity).getSongs().readFromNBT(tag.func_74775_l("tuneData"));
            this.data = ((TileSoundBlock)this.tileEntity).getSongs();
        }
        this.redstoneInteraction = tag.func_74767_n("redstone");
        ((TileSoundBlock)this.tileEntity).setRedstoneInteraction(this.redstoneInteraction);
        this.range = tag.func_74762_e("range");
        ((TileSoundBlock)this.tileEntity).setPlayerRange(this.range);
        if (!((TileSoundBlock)this.tileEntity).func_145831_w().field_72995_K) {
            ((TileSoundBlock)this.tileEntity).func_70296_d();
        }
        this.refreshGui();
    }

    public void sendTuneDataToServer(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("tuneData", (NBTBase)this.data.writeToNBT(new NBTTagCompound()));
            tag.func_74757_a("redstone", this.redstoneInteraction);
            tag.func_74768_a("range", this.range);
            this.sendDataToServer(tag);
        }
    }
}

