/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureScanner;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;

public class ContainerStructureScanner
extends ContainerBase {
    private final ItemStructureSettings settings;

    public ContainerStructureScanner(EntityPlayer player, int x, int y, int z) {
        super(player);
        ItemStack builderItem = player.func_70694_bm();
        if (this.isInvalid(builderItem)) {
            throw new IllegalArgumentException("No scanner in hand");
        }
        this.settings = ItemStructureSettings.getSettingsFor(builderItem);
        this.addPlayerSlots();
        this.removeSlots();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("export")) {
            boolean include = tag.func_74767_n("export");
            String name = tag.func_74779_i("name");
            NBTTagCompound validation = tag.func_74775_l("validation");
            if (ItemStructureScanner.scanStructure(this.player.field_70170_p, this.settings.pos1(), this.settings.pos2(), this.settings.buildKey(), this.settings.face(), name, include, validation)) {
                this.settings.clearSettings();
            }
        }
        if (tag.func_74764_b("reset")) {
            this.settings.clearSettings();
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (par1EntityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack builderItem = par1EntityPlayer.func_70694_bm();
        if (this.isInvalid(builderItem)) {
            return;
        }
        ItemStructureSettings.setSettingsFor(builderItem, this.settings);
    }

    private boolean isInvalid(ItemStack stack) {
        return stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemStructureScanner);
    }

    public void export(String name, boolean include, NBTTagCompound validation) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("name", name);
        tag.func_74757_a("export", include);
        tag.func_74782_a("validation", (NBTBase)validation);
        this.sendDataToServer(tag);
    }
}

