/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gamedata;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;

public class TownMap
extends WorldSavedData {
    private List<StructureBB> boundingBoxes = new ArrayList<StructureBB>();

    public TownMap(String name) {
        super(name);
    }

    public void setGenerated(StructureBB bb) {
        this.boundingBoxes.add(bb);
        this.func_76185_a();
    }

    public float getClosestTown(int bx, int bz, float defaultVal) {
        float distance = defaultVal;
        if (this.boundingBoxes != null) {
            for (StructureBB bb : this.boundingBoxes) {
                float d = Trig.getDistance(bx, 0.0, bz, bb.getCenterX(), 0.0, bb.getCenterZ());
                if (!(d < distance)) continue;
                distance = d;
            }
        }
        return distance;
    }

    public boolean isChunkInUse(int cx, int cz) {
        if (!this.boundingBoxes.isEmpty()) {
            cx *= 16;
            cz *= 16;
            for (StructureBB bb : this.boundingBoxes) {
                if (!bb.isPositionIn(cx, bb.min.y, cz)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersectsWithTown(StructureBB bb) {
        for (StructureBB tbb : this.boundingBoxes) {
            if (!tbb.crossWith(bb)) continue;
            return true;
        }
        return false;
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("boundingBoxes", 10);
        this.boundingBoxes.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            StructureBB bb = new StructureBB(new BlockPosition(), new BlockPosition());
            bb.readFromNBT(list.func_150305_b(i));
            this.boundingBoxes.add(bb);
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (StructureBB bb : this.boundingBoxes) {
            list.func_74742_a((NBTBase)bb.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("boundingBoxes", (NBTBase)list);
    }
}

