/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.entity.WatchedData;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.gui.elements.Tooltip;
import net.shadowmage.ancientwarfare.structure.gui.GuiSpawnerAdvancedEntitySelection;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;

public class GuiSpawnerAdvancedAddEntity
extends GuiContainerBase {
    private CompositeScrolled area;
    private final GuiContainerBase parent;
    private final SpawnerSettings.EntitySpawnGroup group;
    private SpawnerSettings.EntitySpawnSettings settings;
    private final boolean showAddButton;
    private final List<String> tagInput = new ArrayList<String>();
    private boolean showAddTagButton = true;
    private final HashMap<Button, Integer> buttonToLineMap = new HashMap();
    private final HashMap<Text, Integer> textToLineMap = new HashMap();
    private WatchedData.Type[] dataType;
    private int[] dataKey;
    private String[] dataValue;

    public GuiSpawnerAdvancedAddEntity(GuiContainerBase parent, SpawnerSettings.EntitySpawnGroup group, SpawnerSettings.EntitySpawnSettings settings) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.group = group;
        this.settings = settings;
        if (this.settings == null) {
            this.showAddButton = true;
            this.settings = new SpawnerSettings.EntitySpawnSettings();
        } else {
            this.showAddButton = false;
        }
        this.loadData();
    }

    private void loadData() {
        List<WatchedData> data = this.settings.getCustomData();
        int size = data.size();
        this.dataType = new WatchedData.Type[size];
        this.dataKey = new int[size];
        this.dataValue = new String[size];
        int i = 0;
        for (WatchedData d : data) {
            this.dataType[i] = d.getType();
            this.dataKey[i] = d.func_75672_a();
            this.dataValue[i] = this.dataType[i].toString(d.func_75669_b());
            ++i;
        }
        NBTTagCompound tag = this.settings.getCustomTag();
        if (tag != null) {
            String[] splits;
            for (String t : splits = tag.toString().split("}")) {
                this.tagInput.add(t + "}");
            }
            this.showAddTagButton = false;
        }
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    @Override
    public void initElements() {
        Button button;
        if (this.showAddButton) {
            button = new Button(8, 8, 160, 12, "guistrings.spawner.add_entity"){

                @Override
                protected void onPressed() {
                    GuiSpawnerAdvancedAddEntity.this.group.addSpawnSetting(GuiSpawnerAdvancedAddEntity.this.settings);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSpawnerAdvancedAddEntity.this.parent);
                    GuiSpawnerAdvancedAddEntity.this.parent.refreshGui();
                }
            };
            this.addGuiElement(button);
        }
        button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                GuiSpawnerAdvancedAddEntity.this.saveData();
                GuiSpawnerAdvancedAddEntity.this.saveTag();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSpawnerAdvancedAddEntity.this.parent);
                GuiSpawnerAdvancedAddEntity.this.parent.refreshGui();
            }
        };
        this.addGuiElement(button);
        Label label = new Label(8, 26, "guistrings.spawner.set_entity_properties");
        this.addGuiElement(label);
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
    }

    private void saveData() {
        ArrayList<WatchedData> dataList = new ArrayList<WatchedData>();
        for (int i = 0; i < this.dataType.length; ++i) {
            try {
                WatchedData data = new WatchedData(this.dataType[i], this.dataKey[i], this.dataValue[i]);
                if (!data.isValid() || dataList.contains((Object)data)) continue;
                dataList.add(data);
                continue;
            }
            catch (Throwable data) {
                // empty catch block
            }
        }
        Collections.sort(dataList, WatchedData.IndexSorter.INSTANCE);
        this.settings.getCustomData().clear();
        for (WatchedData data : dataList) {
            this.settings.addCustomData(data);
        }
    }

    private void saveTag() {
        if (!this.tagInput.isEmpty()) {
            StringBuilder tagBuffer = new StringBuilder();
            for (String string : this.tagInput) {
                tagBuffer.append(string);
            }
            String tag = tagBuffer.toString();
            try {
                NBTBase base = JsonToNBT.func_150315_a((String)tag);
                if (base instanceof NBTTagCompound && !((NBTTagCompound)base).func_82582_d()) {
                    this.settings.setCustomSpawnTag((NBTTagCompound)base);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            this.settings.setCustomSpawnTag(null);
        }
    }

    @Override
    public void setupElements() {
        Text text;
        Tooltip tip;
        this.area.clearElements();
        this.buttonToLineMap.clear();
        int lineNumber = 0;
        int totalHeight = 8;
        Label label = new Label(8, totalHeight, "guistrings.spawner.select_entity");
        this.area.addGuiElement(label);
        Button button = new Button(100, totalHeight, 120, 12, this.settings.getEntityName()){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSpawnerAdvancedEntitySelection(GuiSpawnerAdvancedAddEntity.this, GuiSpawnerAdvancedAddEntity.this.settings));
            }
        };
        this.area.addGuiElement(button);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.min");
        this.area.addGuiElement(label);
        NumberInput input = new NumberInput(120, totalHeight, 30, this.settings.getSpawnMin(), this){

            @Override
            public void onValueUpdated(float value) {
                GuiSpawnerAdvancedAddEntity.this.settings.setSpawnCountMin((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.max");
        this.area.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 30, this.settings.getSpawnMax(), this){

            @Override
            public void onValueUpdated(float value) {
                GuiSpawnerAdvancedAddEntity.this.settings.setSpawnCountMax((int)value);
            }
        };
        input.setIntegerValue();
        this.area.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.total");
        this.area.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 30, this.settings.getSpawnTotal(), this){

            @Override
            public void onValueUpdated(float value) {
                GuiSpawnerAdvancedAddEntity.this.settings.setSpawnLimitTotal((int)value);
            }
        };
        input.setIntegerValue();
        input.setAllowNegative();
        input.setValue(this.settings.getSpawnTotal());
        this.area.addGuiElement(input);
        Checkbox box = new Checkbox(8, totalHeight += 12, 16, 16, "guistrings.spawner.force_spawn"){

            @Override
            public void onToggled() {
                GuiSpawnerAdvancedAddEntity.this.settings.toggleForce();
            }
        };
        box.setChecked(this.settings.isForced());
        this.area.addGuiElement(box);
        label = new Label(8, totalHeight += 16, "guistrings.spawner.custom_tag");
        this.area.addGuiElement(label);
        totalHeight += 12;
        if (this.showAddTagButton) {
            button = new Button(8, totalHeight, 120, 12, "guistrings.spawner.add_custom_tag"){

                @Override
                protected void onPressed() {
                    GuiSpawnerAdvancedAddEntity.this.tagInput.add("{");
                    GuiSpawnerAdvancedAddEntity.this.tagInput.add("");
                    GuiSpawnerAdvancedAddEntity.this.tagInput.add("}");
                    GuiSpawnerAdvancedAddEntity.this.refreshGui();
                    GuiSpawnerAdvancedAddEntity.this.showAddTagButton = false;
                }
            };
            tip = new Tooltip(50, 20);
            tip.addTooltipElement(new Label(0, 0, "guistrings.spawner.custom_tag_tip"));
            button.setTooltip(tip);
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        for (String line : this.tagInput) {
            text = new Text(8, totalHeight, 200, line, this){

                @Override
                protected void handleKeyInput(int keyCode, char ch) {
                    super.handleKeyInput(keyCode, ch);
                    int lineNumber = (Integer)GuiSpawnerAdvancedAddEntity.this.textToLineMap.get(this);
                    GuiSpawnerAdvancedAddEntity.this.tagInput.set(lineNumber, this.getText());
                }
            };
            this.textToLineMap.put(text, lineNumber);
            this.area.addGuiElement(text);
            button = new Button(208, totalHeight, 12, 12, "guistrings.spawner.add"){

                @Override
                protected void onPressed() {
                    int lineNumber = (Integer)GuiSpawnerAdvancedAddEntity.this.buttonToLineMap.get(this);
                    GuiSpawnerAdvancedAddEntity.this.tagInput.add(lineNumber, "");
                    GuiSpawnerAdvancedAddEntity.this.refreshGui();
                }
            };
            this.buttonToLineMap.put(button, lineNumber);
            this.area.addGuiElement(button);
            button = new Button(220, totalHeight, 12, 12, "guistrings.spawner.remove"){

                @Override
                protected void onPressed() {
                    int lineNumber = (Integer)GuiSpawnerAdvancedAddEntity.this.buttonToLineMap.get(this);
                    GuiSpawnerAdvancedAddEntity.this.tagInput.remove(lineNumber);
                    if (GuiSpawnerAdvancedAddEntity.this.tagInput.isEmpty()) {
                        GuiSpawnerAdvancedAddEntity.this.showAddTagButton = true;
                    }
                    GuiSpawnerAdvancedAddEntity.this.refreshGui();
                }
            };
            this.buttonToLineMap.put(button, lineNumber);
            this.area.addGuiElement(button);
            totalHeight += 12;
            ++lineNumber;
        }
        label = new Label(8, totalHeight, "guistrings.spawner.custom_data");
        this.area.addGuiElement(label);
        totalHeight += 12;
        if (this.dataType.length < 32) {
            button = new Button(8, totalHeight, 120, 12, "guistrings.spawner.add_custom_data"){

                @Override
                protected void onPressed() {
                    WatchedData.Type[] t = new WatchedData.Type[GuiSpawnerAdvancedAddEntity.this.dataType.length + 1];
                    int[] k = new int[t.length];
                    String[] v = new String[t.length];
                    System.arraycopy(GuiSpawnerAdvancedAddEntity.this.dataType, 0, t, 0, GuiSpawnerAdvancedAddEntity.this.dataType.length);
                    System.arraycopy(GuiSpawnerAdvancedAddEntity.this.dataKey, 0, k, 0, GuiSpawnerAdvancedAddEntity.this.dataType.length);
                    System.arraycopy(GuiSpawnerAdvancedAddEntity.this.dataValue, 0, v, 0, GuiSpawnerAdvancedAddEntity.this.dataType.length);
                    t[t.length - 1] = WatchedData.Type.BYTE;
                    k[k.length - 1] = 19;
                    v[v.length - 1] = "0";
                    GuiSpawnerAdvancedAddEntity.access$902(GuiSpawnerAdvancedAddEntity.this, t);
                    GuiSpawnerAdvancedAddEntity.access$1002(GuiSpawnerAdvancedAddEntity.this, k);
                    GuiSpawnerAdvancedAddEntity.access$1102(GuiSpawnerAdvancedAddEntity.this, v);
                    GuiSpawnerAdvancedAddEntity.this.refreshGui();
                }
            };
            tip = new Tooltip(50, 20);
            tip.addTooltipElement(new Label(0, 0, "guistrings.spawner.custom_data_tip0"));
            button.setTooltip(tip);
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        int i = 0;
        while (i < this.dataType.length) {
            final int j = i++;
            text = new Text(8, totalHeight, 140, this.dataValue[j], this){

                @Override
                public void onTextUpdated(String oldText, String newText) {
                    ((GuiSpawnerAdvancedAddEntity)GuiSpawnerAdvancedAddEntity.this).dataValue[j] = newText;
                }
            };
            tip = new Tooltip(50, 20);
            tip.addTooltipElement(new Label(0, 0, "guistrings.spawner.custom_data_tip1"));
            text.setTooltip(tip);
            this.area.addGuiElement(text);
            input = new NumberInput(150, totalHeight, 15, this.dataKey[j], this){

                @Override
                public void onValueUpdated(float value) {
                    if (value > 31.0f) {
                        value = 31.0f;
                    }
                    ((GuiSpawnerAdvancedAddEntity)GuiSpawnerAdvancedAddEntity.this).dataKey[j] = (int)value;
                }
            };
            input.setIntegerValue();
            tip = new Tooltip(50, 20);
            tip.addTooltipElement(new Label(0, 0, "guistrings.spawner.custom_data_tip2"));
            input.setTooltip(tip);
            this.area.addGuiElement(input);
            button = new Button(170, totalHeight, 50, 12, this.dataType[j].name()){

                @Override
                protected void onPressed() {
                    ((GuiSpawnerAdvancedAddEntity)GuiSpawnerAdvancedAddEntity.this).dataType[j] = GuiSpawnerAdvancedAddEntity.this.dataType[j].next();
                    this.setText(GuiSpawnerAdvancedAddEntity.this.dataType[j].name());
                }
            };
            tip = new Tooltip(50, 20);
            tip.addTooltipElement(new Label(0, 0, "guistrings.spawner.custom_data_tip3"));
            button.setTooltip(tip);
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    static /* synthetic */ WatchedData.Type[] access$902(GuiSpawnerAdvancedAddEntity x0, WatchedData.Type[] x1) {
        x0.dataType = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1002(GuiSpawnerAdvancedAddEntity x0, int[] x1) {
        x0.dataKey = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1102(GuiSpawnerAdvancedAddEntity x0, String[] x1) {
        x0.dataValue = x1;
        return x1;
    }
}

