/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureScanner;
import net.shadowmage.ancientwarfare.structure.gui.GuiDimensionSelection;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureBiomeSelection;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureBlockSelection;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureIncorrectName;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureValidationSettings;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;

public class GuiStructureScanner
extends GuiContainerBase<ContainerStructureScanner> {
    private Text nameInput;
    private Label validationTypeLabel;
    private Checkbox includeOnExport;
    protected StructureValidationType validationType = StructureValidationType.GROUND;
    protected StructureValidator validator = this.validationType.getValidator();

    public GuiStructureScanner(ContainerBase par1Container) {
        super(par1Container);
        this.shouldCloseOnVanillaKeys = false;
    }

    @Override
    public void initElements() {
        Label label = new Label(8, 8, StatCollector.func_74838_a((String)"guistrings.input_name") + ":");
        this.addGuiElement(label);
        this.nameInput = new Text(8, 20, 160, "", this);
        this.nameInput.removeAllowedChars('/', '\\', '$', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', ':', ';', '\"', '\'', '+', '=', '<', '>', '?', '.', ',', '[', ']', '{', '}', '|');
        this.addGuiElement(this.nameInput);
        Button button = new Button(193, 8, 55, 16, "guistrings.export");
        button.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureScanner.this.export();
                }
                return true;
            }
        });
        this.addGuiElement(button);
        button = new Button(193, 24, 55, 16, "guistrings.cancel"){

            @Override
            protected void onPressed() {
                GuiStructureScanner.this.closeGui();
            }
        };
        this.addGuiElement(button);
        int totalHeight = 36;
        Checkbox box = new Checkbox(8, totalHeight, 16, 16, "guistrings.include_immediately");
        box.setChecked(true);
        this.addGuiElement(box);
        this.includeOnExport = box;
        this.validationTypeLabel = new Label(8, totalHeight += 24, StatCollector.func_74838_a((String)"guistrings.validation_type") + " " + this.validationType.getName());
        this.addGuiElement(this.validationTypeLabel);
        button = new Button(8, totalHeight += 10, 120, 16, "guistrings.setup_validation"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStructureValidationSettings(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(button);
        button = new Button(8, totalHeight += 16, 120, 16, "guistrings.select_biomes"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStructureBiomeSelection(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(button);
        button = new Button(8, totalHeight += 16, 120, 16, "guistrings.select_blocks"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStructureBlockSelection(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(button);
        button = new Button(8, totalHeight += 16, 120, 16, "guistrings.select_dimensions"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDimensionSelection(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(button);
        totalHeight += 16;
    }

    @Override
    public void setupElements() {
        this.validationTypeLabel.setText(StatCollector.func_74838_a((String)"guistrings.validation_type") + " " + this.validationType.getName());
    }

    private void export() {
        String name = this.nameInput.getText();
        if (!this.validateName(name)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStructureIncorrectName(this));
        } else {
            NBTTagCompound val = new NBTTagCompound();
            this.validator.writeToNBT(val);
            ((ContainerStructureScanner)((Object)this.getContainer())).export(name, this.includeOnExport.checked(), val);
            this.closeGui();
        }
    }

    private boolean validateName(String name) {
        if (name.equals("")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (this.validateChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean validateChar(char ch) {
        return ch != File.separatorChar;
    }
}

