/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.gui.elements.TexturedRectangle;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureSelectionBase;
import net.shadowmage.ancientwarfare.structure.gui.ComparatorStructureTemplateClient;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateClient;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManagerClient;

public class GuiStructureSelectionBase
extends GuiContainerBase<ContainerStructureSelectionBase> {
    private Text filterInput;
    private StructureTemplateClient currentSelection;
    private CompositeScrolled selectionArea;
    private Label selection;
    private final ComparatorStructureTemplateClient sorter = new ComparatorStructureTemplateClient();
    private TexturedRectangle rect;
    private CompositeScrolled resourceArea;

    public GuiStructureSelectionBase(ContainerBase par1Container) {
        super(par1Container, 400, 240);
        this.sorter.setFilterText("");
    }

    @Override
    public void initElements() {
        this.addGuiElement(new Button(this.field_146999_f - 55 - 8, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                if (GuiStructureSelectionBase.this.currentSelection != null) {
                    ((ContainerStructureSelectionBase)((Object)GuiStructureSelectionBase.this.getContainer())).handleNameSelection(((GuiStructureSelectionBase)GuiStructureSelectionBase.this).currentSelection.name);
                    ((ContainerStructureSelectionBase)((Object)GuiStructureSelectionBase.this.getContainer())).addSlots();
                    GuiStructureSelectionBase.this.closeGui();
                }
            }
        });
        Label label = new Label(8, 8, "guistrings.current_selection");
        this.addGuiElement(label);
        this.selection = new Label(8, 20, "");
        this.addGuiElement(this.selection);
        this.filterInput = new Text(8, 30, 224, "", this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                super.handleKeyInput(keyCode, ch);
                GuiStructureSelectionBase.this.refreshGui();
            }
        };
        this.addGuiElement(this.filterInput);
        this.selectionArea = new CompositeScrolled(this, 0, 138, 256, 102);
        this.addGuiElement(this.selectionArea);
        this.rect = new TexturedRectangle(43, 42, 170, 96, (ResourceLocation)null, 512, 288, 0, 0, 512, 288);
        this.addGuiElement(this.rect);
        this.resourceArea = new CompositeScrolled(this, 256, 40, 144, 200);
        this.addGuiElement(this.resourceArea);
        StructureTemplateClient t = StructureTemplateManagerClient.instance().getClientTemplate(((ContainerStructureSelectionBase)((Object)this.getContainer())).structureName);
        this.setSelection(t);
    }

    @Override
    public void setupElements() {
        this.selectionArea.clearElements();
        this.setSelectionName(this.currentSelection == null ? "guistrings.none" : this.currentSelection.name);
        Collection<StructureTemplateClient> templatesC = this.getTemplatesForDisplay();
        ArrayList<StructureTemplateClient> templates = new ArrayList<StructureTemplateClient>();
        templates.addAll(templatesC);
        this.sorter.setFilterText(this.filterInput.getText());
        Collections.sort(templates, this.sorter);
        int totalHeight = 8;
        for (StructureTemplateClient template : templates) {
            TemplateButton button = new TemplateButton(8, totalHeight, template);
            this.selectionArea.addGuiElement(button);
            totalHeight += 12;
        }
        this.selectionArea.setAreaSize(totalHeight + 8);
    }

    protected Collection<StructureTemplateClient> getTemplatesForDisplay() {
        return StructureTemplateManagerClient.instance().getClientStructures();
    }

    private void setSelection(StructureTemplateClient template) {
        this.resourceArea.clearElements();
        int totalHeight = 8;
        this.currentSelection = template;
        this.setSelectionName(template == null ? "guistrings.none" : template.name);
        if (template != null) {
            ResourceLocation l = StructureTemplateManagerClient.instance().getImageFor(template.name);
            this.rect.setTexture(l);
            List<ItemStack> resources = template.resourceList;
            for (ItemStack stack : resources) {
                ItemSlot item = new ItemSlot(8, totalHeight, stack, this);
                this.resourceArea.addGuiElement(item);
                totalHeight += 18;
            }
        } else {
            this.rect.setTexture(null);
        }
        this.resourceArea.setAreaSize(totalHeight + 8);
    }

    public void setSelectionName(String name) {
        this.selection.setText(name);
    }

    private class TemplateButton
    extends Button {
        StructureTemplateClient template;

        public TemplateButton(int topLeftX, int topLeftY, StructureTemplateClient template) {
            super(topLeftX, topLeftY, 232, 12, template.name);
            this.template = template;
        }

        @Override
        protected void onPressed() {
            GuiStructureSelectionBase.this.setSelection(this.template);
        }
    }
}

