/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateClient;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManagerClient;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilderTicked;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureBuilder;

public class ItemBlockStructureBuilder
extends ItemBlock
implements IBoxRenderer {
    List<ItemStack> displayCache = null;

    public ItemBlockStructureBuilder(Block p_i45328_1_) {
        super(p_i45328_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        String name = "corrupt_item";
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("structureName")) {
            name = par1ItemStack.func_77978_p().func_74779_i("structureName");
        }
        par3List.add(StatCollector.func_74838_a((String)"guistrings.structure.structure_name") + ": " + name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List p_150895_3_) {
        if (this.displayCache == null) {
            this.displayCache = new ArrayList<ItemStack>();
            List<StructureTemplateClient> templates = StructureTemplateManagerClient.instance().getSurvivalStructures();
            for (StructureTemplateClient t : templates) {
                ItemStack item = new ItemStack((Item)this);
                item.func_77983_a("structureName", (NBTBase)new NBTTagString(t.name));
                this.displayCache.add(item);
            }
        }
        p_150895_3_.addAll(this.displayCache);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        TileEntity te;
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("structureName")) {
            return false;
        }
        boolean val = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (!world.field_72995_K && val && (te = world.func_147438_o(x, y, z)) instanceof TileStructureBuilder) {
            TileStructureBuilder tb = (TileStructureBuilder)te;
            tb.setOwner(player);
            String name = stack.func_77978_p().func_74779_i("structureName");
            StructureTemplate t = StructureTemplateManager.INSTANCE.getTemplate(name);
            if (t != null) {
                int face = BlockTools.getPlayerFacingFromYaw(player.field_70177_z);
                BlockPosition p = new BlockPosition(x, y, z).moveForward(face, t.zSize - 1 - t.zOffset + 1);
                tb.setBuilder(new StructureBuilderTicked(world, t, face, p.x, p.y, p.z));
            }
        }
        return val;
    }

    @Override
    public void renderBox(EntityPlayer player, ItemStack stack, float delta) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("structureName")) {
            return;
        }
        String name = stack.func_77978_p().func_74779_i("structureName");
        StructureTemplateClient t = StructureTemplateManagerClient.instance().getClientTemplate(name);
        if (t == null) {
            return;
        }
        BlockPosition hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
        if (hit == null) {
            return;
        }
        IBoxRenderer.Util.renderBoundingBox(player, hit, hit, delta);
        int face = BlockTools.getPlayerFacingFromYaw(player.field_70177_z);
        BlockPosition p2 = hit.moveForward(face, t.zSize - 1 - t.zOffset + 1);
        StructureBB bb = new StructureBB(p2.x, p2.y, p2.z, face, t.xSize, t.ySize, t.zSize, t.xOffset, t.yOffset, t.zOffset);
        IBoxRenderer.Util.renderBoundingBox(player, bb.min, bb.max, delta);
    }
}

