/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.TextureImageBased;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateClient;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public class StructureTemplateManagerClient {
    private HashMap<String, ResourceLocation> clientTemplateImages = new HashMap();
    private HashMap<String, StructureTemplateClient> clientTemplates = new HashMap();
    private static final StructureTemplateManagerClient instance = new StructureTemplateManagerClient();

    private StructureTemplateManagerClient() {
    }

    public static StructureTemplateManagerClient instance() {
        return instance;
    }

    public void onTemplateData(NBTTagCompound tag) {
        if (tag.func_74764_b("singleStructure")) {
            NBTTagCompound structureTag = tag.func_74775_l("singleStructure");
            this.readClientStructure(structureTag);
        } else {
            this.clientTemplateImages.clear();
            this.clientTemplates.clear();
            NBTTagList list = tag.func_150295_c("structureList", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound structureTag = list.func_150305_b(i);
                this.readClientStructure(structureTag);
            }
        }
    }

    private void readClientStructure(NBTTagCompound tag) {
        StructureTemplateClient template = StructureTemplateClient.readFromNBT(tag);
        this.addTemplate(template);
    }

    public void removeTemplate(String name) {
        this.clientTemplates.remove(name);
        this.clientTemplateImages.remove(name);
    }

    public Collection<StructureTemplateClient> getClientStructures() {
        return this.clientTemplates.values();
    }

    public List<StructureTemplateClient> getSurvivalStructures() {
        ArrayList<StructureTemplateClient> clientStructures = new ArrayList<StructureTemplateClient>();
        for (StructureTemplateClient t : this.clientTemplates.values()) {
            if (!t.survival) continue;
            clientStructures.add(t);
        }
        return clientStructures;
    }

    public StructureTemplateClient getClientTemplate(String name) {
        return this.clientTemplates.get(name);
    }

    public void addTemplate(StructureTemplateClient template) {
        this.clientTemplates.put(template.name, template);
        this.loadTemplateImage(template.name + ".png");
    }

    public ResourceLocation getImageFor(String templateName) {
        return this.clientTemplateImages.get(templateName + ".png");
    }

    private void loadTemplateImage(String imageName) {
        String pathBase = "config/ancientwarfare/structures/image_cache/";
        File file = new File(pathBase + imageName);
        ResourceLocation loc = new ResourceLocation("ancientwarfare", pathBase + imageName);
        if (!file.exists()) {
            BufferedImage image = StructureTemplateManager.INSTANCE.getTemplateImage(imageName);
            if (image != null) {
                Minecraft.func_71410_x().field_71446_o.func_110579_a(loc, (ITextureObject)new TextureImageBased(loc, image));
                this.clientTemplateImages.put(imageName, loc);
            }
        } else {
            try {
                BufferedImage image = ImageIO.read(file);
                if (image.getWidth() == AWStructureStatics.structureImageWidth && image.getHeight() == AWStructureStatics.structureImageHeight) {
                    Minecraft.func_71410_x().field_71446_o.func_110579_a(loc, (ITextureObject)new TextureImageBased(loc, image));
                    this.clientTemplateImages.put(imageName, loc);
                } else {
                    AWLog.logError("Error parsing image: " + file.getName() + " image was not of correct size. Found: " + image.getWidth() + "x" + image.getHeight() + "  Needed: " + AWStructureStatics.structureImageWidth + "x" + AWStructureStatics.structureImageHeight);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getMD5(File file) throws IOException {
        int read;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        while ((read = fis.read(buffer)) >= 0) {
            md.update(buffer, 0, read);
        }
        byte[] data = md.digest();
        String md5 = "";
        StringBuilder sb = new StringBuilder(2 * data.length);
        for (byte b : data) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        md5 = sb.toString();
        fis.close();
        return md5;
    }

    public void addStructureImage(String imageName, BufferedImage image) {
        String pathBase = "config/ancientwarfare/structures/image_cache/";
        try {
            File file = new File(pathBase + imageName);
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadTemplateImage(imageName);
    }
}

