/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build;

import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.Zone;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;

public class StructureBB
extends Zone {
    public StructureBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(new BlockPosition(minX, minY, minZ), new BlockPosition(maxX, maxY, maxZ));
    }

    public StructureBB(int x, int y, int z, int face, StructureTemplate template) {
        this(x, y, z, face, template.xSize, template.ySize, template.zSize, template.xOffset, template.yOffset, template.zOffset);
    }

    public StructureBB(int x, int y, int z, int face, int xSize, int ySize, int zSize, int xOffset, int yOffset, int zOffset) {
        BlockPosition c1 = new BlockPosition(x, y, z).moveLeft(face, xOffset).moveForward(face, zOffset).moveUp(-yOffset);
        BlockPosition c2 = c1.moveRight(face, xSize - 1).moveForward(face, -(zSize - 1)).moveUp(ySize - 1);
        this.min = BlockTools.getMin(c1, c2);
        this.max = BlockTools.getMax(c1, c2);
    }

    public StructureBB(BlockPosition pos1, BlockPosition pos2) {
        super(pos1, pos2);
    }

    private StructureBB() {
    }

    @Override
    public String toString() {
        return this.min.toString() + " : " + this.max.toString();
    }

    public StructureBB expand(int x, int y, int z) {
        this.min = this.min.sub(new BlockPosition(x, y, z));
        this.max = this.max.offset(x, y, z);
        return this;
    }

    public StructureBB offset(int x, int y, int z) {
        this.min = this.min.offset(x, y, z);
        this.max = this.max.offset(x, y, z);
        return this;
    }

    public int getXSize() {
        return this.max.x - this.min.x + 1;
    }

    public int getZSize() {
        return this.max.z - this.min.z + 1;
    }

    public int getCenterX() {
        return this.min.x + this.getXSize() / 2 - 1;
    }

    public int getCenterZ() {
        return this.min.z + this.getZSize() / 2 - 1;
    }

    public StructureBB getFrontCorners(int face, BlockPosition min, BlockPosition max) {
        min = this.getFLCorner(face, min);
        max = this.getFRCorner(face, max);
        int minX = Math.min(min.x, max.x);
        int maxX = Math.max(min.x, max.x);
        int minZ = Math.min(min.z, max.z);
        int maxZ = Math.max(min.z, max.z);
        StructureBB result = new StructureBB();
        result.min = new BlockPosition(minX, min.y, minZ);
        result.max = new BlockPosition(maxX, max.y, maxZ);
        return result;
    }

    public StructureBB getLeftCorners(int face, BlockPosition min, BlockPosition max) {
        min = this.getFLCorner(face, min);
        max = this.getRLCorner(face, max);
        int minX = Math.min(min.x, max.x);
        int maxX = Math.max(min.x, max.x);
        int minZ = Math.min(min.z, max.z);
        int maxZ = Math.max(min.z, max.z);
        StructureBB result = new StructureBB();
        result.min = new BlockPosition(minX, min.y, minZ);
        result.max = new BlockPosition(maxX, max.y, maxZ);
        return result;
    }

    public StructureBB getRearCorners(int face, BlockPosition min, BlockPosition max) {
        min = this.getRLCorner(face, min);
        max = this.getRRCorner(face, max);
        int minX = Math.min(min.x, max.x);
        int maxX = Math.max(min.x, max.x);
        int minZ = Math.min(min.z, max.z);
        int maxZ = Math.max(min.z, max.z);
        StructureBB result = new StructureBB();
        result.min = new BlockPosition(minX, min.y, minZ);
        result.max = new BlockPosition(maxX, max.y, maxZ);
        return result;
    }

    public StructureBB getRightCorners(int face, BlockPosition min, BlockPosition max) {
        min = this.getFRCorner(face, min);
        max = this.getRRCorner(face, max);
        int minX = Math.min(min.x, max.x);
        int maxX = Math.max(min.x, max.x);
        int minZ = Math.min(min.z, max.z);
        int maxZ = Math.max(min.z, max.z);
        StructureBB result = new StructureBB();
        result.min = new BlockPosition(minX, min.y, minZ);
        result.max = new BlockPosition(maxX, max.y, maxZ);
        return result;
    }

    private BlockPosition getFLCorner(int face, BlockPosition out) {
        switch (face) {
            case 0: {
                return new BlockPosition(this.max.x, this.min.y, this.min.z);
            }
            case 1: {
                return new BlockPosition(this.max.x, this.min.y, this.max.z);
            }
            case 2: {
                return new BlockPosition(this.min.x, this.min.y, this.max.z);
            }
            case 3: {
                return this.min;
            }
        }
        return out;
    }

    private BlockPosition getFRCorner(int face, BlockPosition out) {
        switch (face) {
            case 0: {
                return this.min;
            }
            case 1: {
                return new BlockPosition(this.max.x, this.min.y, this.min.z);
            }
            case 2: {
                return new BlockPosition(this.max.x, this.min.y, this.max.z);
            }
            case 3: {
                return new BlockPosition(this.min.x, this.min.y, this.max.z);
            }
        }
        return out;
    }

    public BlockPosition getRLCorner(int face, BlockPosition out) {
        switch (face) {
            case 0: {
                return new BlockPosition(this.max.x, this.min.y, this.max.z);
            }
            case 1: {
                return new BlockPosition(this.min.x, this.min.y, this.max.z);
            }
            case 2: {
                return this.min;
            }
            case 3: {
                return new BlockPosition(this.max.x, this.min.y, this.min.z);
            }
        }
        return out;
    }

    private BlockPosition getRRCorner(int face, BlockPosition out) {
        switch (face) {
            case 0: {
                return new BlockPosition(this.min.x, this.min.y, this.max.z);
            }
            case 1: {
                return this.min;
            }
            case 2: {
                return new BlockPosition(this.max.x, this.min.y, this.min.z);
            }
            case 3: {
                return new BlockPosition(this.max.x, this.min.y, this.max.z);
            }
        }
        return out;
    }

    public StructureBB copy() {
        return new StructureBB(this.min.copy(), this.max.copy());
    }
}

