/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuildingException;

public class StructureBuilder
implements IStructureBuilder {
    protected StructureTemplate template;
    protected World world;
    protected BlockPosition buildOrigin;
    protected int buildFace;
    protected int turns;
    protected int maxPriority = 4;
    protected int currentPriority;
    protected int currentX;
    protected int currentY;
    protected int currentZ;
    protected int destXSize;
    protected int destYSize;
    protected int destZSize;
    protected BlockPosition destination;
    protected StructureBB bb;
    private boolean isFinished = false;

    public StructureBuilder(World world, StructureTemplate template, int face, int x, int y, int z) {
        this(world, template, face, new BlockPosition(x, y, z), new StructureBB(x, y, z, face, template));
    }

    public StructureBuilder(World world, StructureTemplate template, int face, BlockPosition buildKey, StructureBB bb) {
        this.world = world;
        this.template = template;
        this.buildFace = face;
        this.bb = bb;
        this.buildOrigin = buildKey;
        this.destination = new BlockPosition();
        this.currentZ = 0;
        this.currentY = 0;
        this.currentX = 0;
        this.destXSize = template.xSize;
        this.destYSize = template.ySize;
        this.destZSize = template.zSize;
        this.currentPriority = 0;
        this.turns = (face + 2) % 4;
        for (int i = 0; i < this.turns; ++i) {
            int swap = this.destXSize;
            this.destXSize = this.destZSize;
            this.destZSize = swap;
        }
        this.incrementDestination();
    }

    public StructureTemplate getTemplate() {
        return this.template;
    }

    public StructureBB getBoundingBox() {
        return this.bb;
    }

    protected StructureBuilder() {
        this.destination = new BlockPosition();
        this.buildOrigin = new BlockPosition();
    }

    public void instantConstruction() {
        try {
            while (!this.isFinished()) {
                TemplateRule rule = this.template.getRuleAt(this.currentX, this.currentY, this.currentZ);
                this.placeCurrentPosition(rule);
                this.increment();
            }
        }
        catch (Exception e) {
            TemplateRule rule = this.template.getRuleAt(this.currentX, this.currentY, this.currentZ);
            throw new RuntimeException("Caught exception while constructing template blocks: " + rule, e);
        }
        this.placeEntities();
    }

    protected void placeEntities() {
        TemplateRuleEntity[] rules;
        for (TemplateRuleEntity rule : rules = this.template.getEntityRules()) {
            if (rule == null) continue;
            this.destination = BlockTools.rotateInArea(rule.getPosition(), this.template.xSize, this.template.zSize, this.turns).offsetBy(this.bb.min);
            try {
                rule.handlePlacement(this.world, this.turns, this.destination.x, this.destination.y, this.destination.z, this);
            }
            catch (StructureBuildingException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void placeBlock(int x, int y, int z, Block block, int meta, int priority) {
        if (y <= 0 || y >= this.world.func_72800_K()) {
            return;
        }
        Chunk chunk = this.world.func_72938_d(x, z);
        ExtendedBlockStorage stc = chunk.func_76587_i()[y >> 4];
        if (stc == null) {
            if (block != Blocks.field_150350_a) {
                this.world.func_147465_d(x, y, z, block, meta, 2);
            }
        } else {
            TileEntity te;
            int cx = x & 0xF;
            int cz = z & 0xF;
            chunk.func_150805_f(cx, y, cz);
            stc.func_150818_a(cx, y & 0xF, cz, block);
            stc.func_76654_b(cx, y & 0xF, cz, meta);
            if (block.hasTileEntity(meta) && (te = block.createTileEntity(this.world, meta)) != null) {
                chunk.func_150812_a(cx, y, cz, te);
                this.world.addTileEntity(te);
            }
            this.world.func_147471_g(x, y, z);
        }
    }

    protected void placeCurrentPosition(TemplateRule rule) {
        if (rule == null) {
            if (this.currentPriority == 0) {
                this.placeAir();
            }
        } else if (rule.shouldPlaceOnBuildPass(this.world, this.turns, this.destination.x, this.destination.y, this.destination.z, this.currentPriority)) {
            this.placeRule(rule);
        }
    }

    protected boolean increment() {
        if (this.isFinished) {
            return false;
        }
        if (this.incrementPosition()) {
            this.incrementDestination();
        } else {
            this.isFinished = true;
        }
        return !this.isFinished;
    }

    protected void placeAir() {
        if (!this.template.getValidationSettings().isPreserveBlocks()) {
            this.template.getValidationSettings().handleClearAction(this.world, this.destination.x, this.destination.y, this.destination.z, this.template, this.bb);
        }
    }

    protected void placeRule(TemplateRule rule) {
        if (this.destination.y <= 0) {
            return;
        }
        try {
            rule.handlePlacement(this.world, this.turns, this.destination.x, this.destination.y, this.destination.z, this);
        }
        catch (StructureBuildingException e) {
            e.printStackTrace();
        }
    }

    protected void incrementDestination() {
        this.destination = BlockTools.rotateInArea(new BlockPosition(this.currentX, this.currentY, this.currentZ), this.template.xSize, this.template.zSize, this.turns).offsetBy(this.bb.min);
    }

    protected boolean incrementPosition() {
        ++this.currentX;
        if (this.currentX >= this.template.xSize) {
            this.currentX = 0;
            ++this.currentZ;
            if (this.currentZ >= this.template.zSize) {
                this.currentZ = 0;
                ++this.currentY;
                if (this.currentY >= this.template.ySize) {
                    this.currentY = 0;
                    ++this.currentPriority;
                    if (this.currentPriority > this.maxPriority) {
                        this.currentPriority = 0;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public float getPercentDoneWithPass() {
        float max = this.template.xSize * this.template.zSize * this.template.ySize;
        float current = this.currentY * (this.template.xSize * this.template.zSize);
        current += (float)(this.currentZ * this.template.xSize);
        return (current += (float)this.currentX) / max;
    }

    public int getPass() {
        return this.currentPriority;
    }

    public int getMaxPasses() {
        return this.maxPriority;
    }
}

