/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;

public class StructureBuilderTicked
extends StructureBuilder {
    public boolean invalid = false;
    private boolean hasClearedArea;
    private int clearX;
    private int clearY;
    private int clearZ;

    public StructureBuilderTicked(World world, StructureTemplate template, int face, int x, int y, int z) {
        super(world, template, face, x, y, z);
        this.clearX = this.bb.min.x;
        this.clearY = this.bb.min.y;
        this.clearZ = this.bb.min.z;
    }

    public StructureBuilderTicked() {
    }

    public void tick(EntityPlayer player) {
        if (!this.hasClearedArea) {
            while (!this.breakClearTargetBlock(player)) {
                if (this.incrementClear()) continue;
                this.hasClearedArea = true;
                break;
            }
            if (!this.incrementClear()) {
                this.hasClearedArea = true;
            }
        } else if (!this.isFinished()) {
            while (!this.isFinished()) {
                TemplateRule rule = this.template.getRuleAt(this.currentX, this.currentY, this.currentZ);
                if (rule == null || !rule.shouldPlaceOnBuildPass(this.world, this.turns, this.destination.x, this.destination.y, this.destination.z, this.currentPriority)) {
                    this.increment();
                    continue;
                }
                this.placeRule(rule);
                break;
            }
            this.increment();
        }
    }

    protected boolean breakClearTargetBlock(EntityPlayer player) {
        return BlockTools.breakBlockAndDrop(this.world, player, this.clearX, this.clearY, this.clearZ);
    }

    protected boolean incrementClear() {
        ++this.clearX;
        if (this.clearX > this.bb.max.x) {
            this.clearX = this.bb.min.x;
            ++this.clearZ;
            if (this.clearZ > this.bb.max.z) {
                ++this.clearY;
                if (this.clearY > this.bb.max.y) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public void readFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("name");
        StructureTemplate template = StructureTemplateManager.INSTANCE.getTemplate(name);
        if (template != null) {
            this.template = template;
            this.currentX = tag.func_74762_e("x");
            this.currentY = tag.func_74762_e("y");
            this.currentZ = tag.func_74762_e("z");
            this.clearX = tag.func_74762_e("cx");
            this.clearY = tag.func_74762_e("cy");
            this.clearZ = tag.func_74762_e("cz");
            this.hasClearedArea = tag.func_74767_n("cleared");
            this.turns = tag.func_74762_e("turns");
            this.buildFace = tag.func_74762_e("buildFace");
            this.maxPriority = tag.func_74762_e("maxPriority");
            this.currentPriority = tag.func_74762_e("currentPriority");
            this.bb = new StructureBB(new BlockPosition(tag.func_74775_l("bbMin")), new BlockPosition(tag.func_74775_l("bbMax")));
            this.buildOrigin = new BlockPosition(tag.func_74775_l("buildOrigin"));
            this.incrementDestination();
        } else {
            this.invalid = true;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.template.name);
        tag.func_74768_a("face", this.buildFace);
        tag.func_74768_a("turns", this.turns);
        tag.func_74768_a("maxPriority", this.maxPriority);
        tag.func_74768_a("currentPriority", this.currentPriority);
        tag.func_74768_a("x", this.currentX);
        tag.func_74768_a("y", this.currentY);
        tag.func_74768_a("z", this.currentZ);
        tag.func_74768_a("cx", this.clearX);
        tag.func_74768_a("cy", this.clearY);
        tag.func_74768_a("cz", this.clearZ);
        tag.func_74757_a("cleared", this.hasClearedArea);
        tag.func_74782_a("buildOrigin", (NBTBase)this.buildOrigin.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("bbMin", (NBTBase)this.bb.min.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("bbMax", (NBTBase)this.bb.max.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public StructureTemplate getTemplate() {
        return this.template;
    }
}

