/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class StructureValidationProperty {
    public static final int DATA_TYPE_UNKNOWN = 0;
    public static final int DATA_TYPE_INT = 1;
    public static final int DATA_TYPE_BYTE = 2;
    public static final int DATA_TYPE_BOOLEAN = 3;
    public static final int DATA_TYPE_FLOAT = 4;
    public static final int DATA_TYPE_STRING = 5;
    public static final int DATA_TYPE_INT_ARRAY = 6;
    public static final int DATA_TYPE_STRING_SET = 7;
    String regName;
    final int dataType;
    Object data;

    private StructureValidationProperty(String regName, int dataType, Object defaultValue) {
        this.regName = regName;
        this.data = defaultValue;
        this.dataType = dataType;
    }

    public StructureValidationProperty(String regName, Object defaultValue) {
        this.regName = regName;
        this.data = defaultValue;
        this.dataType = this.data == null ? 0 : (Integer.class.isInstance(this.data) ? 1 : (Byte.class.isInstance(this.data) ? 2 : (Float.class.isInstance(this.data) ? 4 : (Boolean.class.isInstance(this.data) ? 3 : (String.class.isInstance(this.data) ? 5 : (Set.class.isInstance(this.data) ? 7 : (int[].class.isAssignableFrom(this.data.getClass()) ? 6 : 0)))))));
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getRegName() {
        return this.regName;
    }

    public void setValue(Object value) {
        switch (this.dataType) {
            case 0: {
                this.data = value;
                break;
            }
            case 1: {
                if (!Integer.class.isInstance(value)) break;
                this.data = value;
                break;
            }
            case 2: {
                if (!Byte.class.isInstance(value)) break;
                this.data = value;
                break;
            }
            case 4: {
                if (!Float.class.isInstance(value)) break;
                this.data = value;
                break;
            }
            case 3: {
                if (!Boolean.class.isInstance(value)) break;
                this.data = value;
                break;
            }
            case 5: {
                if (!String.class.isInstance(value)) break;
                this.data = value;
                break;
            }
            case 7: {
                if (!Set.class.isInstance(value)) break;
                this.data = value;
                break;
            }
            case 6: {
                if (!int[].class.isAssignableFrom(value.getClass())) break;
                this.data = value;
            }
        }
    }

    public int getDataInt() {
        if (this.dataType == 1) {
            return (Integer)this.data;
        }
        return 0;
    }

    public int[] getDataIntArray() {
        if (this.dataType == 6) {
            return (int[])this.data;
        }
        return new int[0];
    }

    public float getDataFloat() {
        if (this.dataType == 4) {
            return ((Float)this.data).floatValue();
        }
        return 0.0f;
    }

    public String getDataString() {
        if (this.dataType == 5) {
            return (String)this.data;
        }
        return "";
    }

    public boolean getDataBoolean() {
        if (this.dataType == 3) {
            return (Boolean)this.data;
        }
        return false;
    }

    public Set<String> getDataStringSet() {
        if (this.dataType == 7) {
            return (Set)this.data;
        }
        return new HashSet<String>();
    }

    public void readFromNBT(NBTTagCompound tag) {
        switch (this.dataType) {
            case 1: {
                this.data = tag.func_74762_e(this.regName);
                break;
            }
            case 6: {
                this.data = tag.func_74759_k(this.regName);
                break;
            }
            case 2: {
                this.data = tag.func_74771_c(this.regName);
                break;
            }
            case 4: {
                this.data = Float.valueOf(tag.func_74760_g(this.regName));
                break;
            }
            case 3: {
                this.data = tag.func_74767_n(this.regName);
                break;
            }
            case 5: {
                this.data = tag.func_74779_i(this.regName);
                break;
            }
            case 7: {
                HashSet<String> data = new HashSet<String>();
                NBTTagList names = tag.func_150295_c(this.regName, 8);
                for (int i = 0; i < names.func_74745_c(); ++i) {
                    data.add(names.func_150307_f(i));
                }
                this.data = data;
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        switch (this.dataType) {
            case 1: {
                tag.func_74768_a(this.regName, this.getDataInt());
                break;
            }
            case 6: {
                tag.func_74783_a(this.regName, this.getDataIntArray());
                break;
            }
            case 2: {
                tag.func_74774_a(this.regName, ((Byte)this.data).byteValue());
                break;
            }
            case 4: {
                tag.func_74776_a(this.regName, this.getDataFloat());
                break;
            }
            case 3: {
                tag.func_74757_a(this.regName, this.getDataBoolean());
                break;
            }
            case 5: {
                tag.func_74778_a(this.regName, this.getDataString());
                break;
            }
            case 7: {
                NBTTagList names = new NBTTagList();
                Set<String> data = this.getDataStringSet();
                for (String name : data) {
                    names.func_74742_a((NBTBase)new NBTTagString(name));
                }
                tag.func_74782_a(this.regName, (NBTBase)names);
            }
        }
    }

    public StructureValidationProperty copy() {
        HashSet<String> copy = this.data;
        if (copy != null) {
            if (this.dataType == 7) {
                copy = new HashSet<String>(this.getDataStringSet());
            } else if (this.dataType == 6) {
                int[] temp = this.getDataIntArray();
                copy = (HashSet<String>)new int[temp.length];
                System.arraycopy(temp, 0, copy, 0, temp.length);
            }
        }
        return new StructureValidationProperty(this.regName, this.dataType, copy);
    }
}

