/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationProperty;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorGround;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorHarbor;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorIsland;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorSky;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorUnderground;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorUnderwater;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidatorWater;

public enum StructureValidationType {
    GROUND(StructureValidatorGround.class, new StructureValidationProperty[0]),
    UNDERGROUND(StructureValidatorUnderground.class, new StructureValidationProperty("minGenDepth", 0), new StructureValidationProperty("maxGenDepth", 0), new StructureValidationProperty("minOverfill", 0)),
    SKY(StructureValidatorSky.class, new StructureValidationProperty("minGenHeight", 0), new StructureValidationProperty("maxGenHeight", 0), new StructureValidationProperty("minFlyingHeight", 0)),
    WATER(StructureValidatorWater.class, new StructureValidationProperty[0]),
    UNDERWATER(StructureValidatorUnderwater.class, new StructureValidationProperty("minWaterDepth", 0), new StructureValidationProperty("maxWaterDepth", 0)),
    HARBOR(StructureValidatorHarbor.class, new StructureValidationProperty[0]),
    ISLAND(StructureValidatorIsland.class, new StructureValidationProperty("minWaterDepth", 0), new StructureValidationProperty("maxWaterDepth", 0));

    private Class<? extends StructureValidator> validatorClass;
    private List<StructureValidationProperty> properties = new ArrayList<StructureValidationProperty>();

    private StructureValidationType(Class<? extends StructureValidator> validatorClass, StructureValidationProperty ... props) {
        this.validatorClass = validatorClass;
        this.properties.add(new StructureValidationProperty("survival", false));
        this.properties.add(new StructureValidationProperty("enableWorldGen", false));
        this.properties.add(new StructureValidationProperty("unique", false));
        this.properties.add(new StructureValidationProperty("preserveBlocks", false));
        this.properties.add(new StructureValidationProperty("selectionWeight", 0));
        this.properties.add(new StructureValidationProperty("clusterValue", 0));
        this.properties.add(new StructureValidationProperty("minDuplicateDistance", 0));
        this.properties.add(new StructureValidationProperty("borderSize", 0));
        this.properties.add(new StructureValidationProperty("maxLeveling", 0));
        this.properties.add(new StructureValidationProperty("maxFill", 0));
        this.properties.add(new StructureValidationProperty("biomeWhiteList", false));
        this.properties.add(new StructureValidationProperty("dimensionWhiteList", false));
        this.properties.add(new StructureValidationProperty("biomeList", new HashSet()));
        this.properties.add(new StructureValidationProperty("blockList", new HashSet()));
        this.properties.add(new StructureValidationProperty("dimensionList", new int[0]));
        this.properties.add(new StructureValidationProperty("blockSwap", false));
        Collections.addAll(this.properties, props);
    }

    public List<StructureValidationProperty> getValidationProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public StructureValidator getValidator() {
        try {
            return this.validatorClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static StructureValidationType getTypeFromName(String name) {
        if (name == null) {
            return null;
        }
        try {
            return StructureValidationType.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegal) {
            return null;
        }
    }

    public static class ValidationProperty {
        public String displayName;
        public String propertyName;
        public Class clz;

        public ValidationProperty(String reg, String display, Class clz) {
            this.propertyName = reg;
            this.displayName = display;
            this.clz = clz;
        }
    }
}

