/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public class StructureValidatorGround
extends StructureValidator {
    public StructureValidatorGround() {
        super(StructureValidationType.GROUND);
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, int face, StructureTemplate template) {
        Block block = world.func_147439_a(x, y - 1, z);
        Set<String> validTargetBlocks = this.getTargetBlocks();
        String name = BlockDataManager.INSTANCE.getNameForBlock(block);
        if (block == null || !validTargetBlocks.contains(name)) {
            AWLog.logDebug("Rejecting due to target block mismatch of: " + name + " at: " + x + "," + y + "," + z + " Valid blocks are: " + validTargetBlocks);
            return false;
        }
        return true;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        int minY = this.getMinY(template, bb);
        int maxY = this.getMaxY(template, bb);
        return this.validateBorderBlocks(world, template, bb, minY, maxY, false);
    }

    @Override
    public void preGeneration(World world, BlockPosition pos, int face, StructureTemplate template, StructureBB bb) {
        this.prePlacementBorder(world, template, bb);
        this.prePlacementUnderfill(world, template, bb);
    }

    @Override
    public void postGeneration(World world, BlockPosition origin, StructureBB bb) {
        BiomeGenBase biome = world.func_72807_a(origin.x, origin.z);
        if (biome != null && biome.func_76746_c()) {
            WorldStructureGenerator.sprinkleSnow(world, bb, this.getBorderSize());
        }
    }

    @Override
    protected void borderLeveling(World world, int x, int z, StructureTemplate template, StructureBB bb) {
        int y;
        Block block;
        if (this.getMaxLeveling() <= 0) {
            return;
        }
        int topFilledY = WorldStructureGenerator.getTargetY(world, x, z, true);
        int step = WorldStructureGenerator.getStepNumber(x, z, bb.min.x, bb.max.x, bb.min.z, bb.max.z);
        for (int y2 = bb.min.y + template.yOffset + step; y2 <= topFilledY; ++y2) {
            this.handleClearAction(world, x, y2, z, template, bb);
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        BlockGrass fillBlock = Blocks.field_150349_c;
        if (biome != null && biome.field_76752_A != null) {
            fillBlock = biome.field_76752_A;
        }
        if ((block = world.func_147439_a(x, y = bb.min.y + template.yOffset + step - 1, z)) != null && block != Blocks.field_150350_a && block != Blocks.field_150358_i && block != Blocks.field_150355_j && !AWStructureStatics.skippableBlocksContains(block)) {
            world.func_147449_b(x, y, z, (Block)fillBlock);
        }
        int skipCount = 0;
        for (int y1 = y + 1; y1 < world.func_72800_K(); ++y1) {
            block = world.func_147439_a(x, y1, z);
            if (block == Blocks.field_150350_a) {
                if (++skipCount < 10) continue;
                break;
            }
            skipCount = 0;
            if (!AWStructureStatics.skippableBlocksContains(block)) continue;
            world.func_147468_f(x, y1, z);
        }
    }
}

