/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public class StructureValidatorIsland
extends StructureValidator {
    int minWaterDepth;
    int maxWaterDepth;

    public StructureValidatorIsland() {
        super(StructureValidationType.ISLAND);
    }

    @Override
    protected void readFromLines(List<String> lines) {
        for (String line : lines) {
            if (StructureValidatorIsland.startLow(line, "minwaterdepth=")) {
                this.minWaterDepth = StringTools.safeParseInt("=", line);
                continue;
            }
            if (!StructureValidatorIsland.startLow(line, "maxwaterdepth=")) continue;
            this.maxWaterDepth = StringTools.safeParseInt("=", line);
        }
    }

    @Override
    protected void write(BufferedWriter out) throws IOException {
        out.write("minWaterDepth=" + this.minWaterDepth);
        out.newLine();
        out.write("minWaterDepth=" + this.maxWaterDepth);
        out.newLine();
    }

    @Override
    protected void setDefaultSettings(StructureTemplate template) {
        this.minWaterDepth = template.yOffset / 2;
        this.maxWaterDepth = template.yOffset;
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, int face, StructureTemplate template) {
        int water = 0;
        int startY = y - 1;
        water = startY - (y = WorldStructureGenerator.getTargetY(world, x, z, true) + 1) + 1;
        return water >= this.minWaterDepth && water <= this.maxWaterDepth;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        int minY = y - this.maxWaterDepth;
        int maxY = y - this.minWaterDepth;
        return this.validateBorderBlocks(world, template, bb, minY, maxY, true);
    }

    @Override
    public void preGeneration(World world, BlockPosition pos, int face, StructureTemplate template, StructureBB bb) {
        Set<String> validTargetBlocks = this.getTargetBlocks();
        for (int bx = bb.min.x; bx <= bb.max.x; ++bx) {
            for (int bz = bb.min.z; bz <= bb.max.z; ++bz) {
                Block block;
                for (int by = bb.min.y - 1; !(by <= 0 || (block = world.func_147439_a(bx, by, bz)) != null && validTargetBlocks.contains(BlockDataManager.INSTANCE.getNameForBlock(block))); --by) {
                    world.func_147449_b(bx, by, bz, Blocks.field_150346_d);
                }
            }
        }
    }

    @Override
    public void handleClearAction(World world, int x, int y, int z, StructureTemplate template, StructureBB bb) {
        int maxWaterY = bb.min.y + template.yOffset - 1;
        if (y <= maxWaterY) {
            world.func_147449_b(x, y, z, Blocks.field_150355_j);
        } else {
            super.handleClearAction(world, x, y, z, template, bb);
        }
    }
}

