/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;

public class StructureValidatorSky
extends StructureValidator {
    int minGenerationHeight;
    int maxGenerationHeight;
    int minFlyingHeight;

    public StructureValidatorSky() {
        super(StructureValidationType.SKY);
    }

    @Override
    protected void readFromLines(List<String> lines) {
        for (String line : lines) {
            if (StructureValidatorSky.startLow(line, "mingenerationheight=")) {
                this.minGenerationHeight = StringTools.safeParseInt("=", line);
                continue;
            }
            if (StructureValidatorSky.startLow(line, "maxgenerationheight=")) {
                this.maxGenerationHeight = StringTools.safeParseInt("=", line);
                continue;
            }
            if (!StructureValidatorSky.startLow(line, "minflyingheight=")) continue;
            this.minFlyingHeight = StringTools.safeParseInt("=", line);
        }
    }

    @Override
    protected void write(BufferedWriter out) throws IOException {
        out.write("minGenerationHeight=" + this.minGenerationHeight);
        out.newLine();
        out.write("maxGenerationHeight=" + this.maxGenerationHeight);
        out.newLine();
        out.write("minFlyingHeight=" + this.minFlyingHeight);
        out.newLine();
    }

    @Override
    protected void setDefaultSettings(StructureTemplate template) {
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, int face, StructureTemplate template) {
        int remainingHeight = world.func_72940_L() - this.minFlyingHeight - (template.ySize - template.yOffset);
        return y < remainingHeight;
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        int range = this.maxGenerationHeight - this.minGenerationHeight + 1;
        return y + this.minFlyingHeight + world.field_73012_v.nextInt(range);
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        int maxY = this.minGenerationHeight - this.minFlyingHeight;
        return this.validateBorderBlocks(world, template, bb, 0, maxY, false);
    }

    @Override
    public void preGeneration(World world, BlockPosition pos, int face, StructureTemplate template, StructureBB bb) {
    }
}

