/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public class StructureValidatorUnderwater
extends StructureValidator {
    int minWaterDepth;
    int maxWaterDepth;

    public StructureValidatorUnderwater() {
        super(StructureValidationType.UNDERWATER);
    }

    @Override
    protected void readFromLines(List<String> lines) {
        for (String line : lines) {
            if (StructureValidatorUnderwater.startLow(line, "minwaterdepth=")) {
                this.minWaterDepth = StringTools.safeParseInt("=", line);
                continue;
            }
            if (!StructureValidatorUnderwater.startLow(line, "maxwaterdepth=")) continue;
            this.maxWaterDepth = StringTools.safeParseInt("=", line);
        }
    }

    @Override
    protected void write(BufferedWriter out) throws IOException {
        out.write("minWaterDepth=" + this.minWaterDepth);
        out.newLine();
        out.write("maxWaterDepth=" + this.maxWaterDepth);
        out.newLine();
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, int face, StructureTemplate template) {
        int water = 0;
        int startY = y;
        water = startY - (y = WorldStructureGenerator.getTargetY(world, x, z, true) + 1);
        return water >= this.minWaterDepth && water <= this.maxWaterDepth;
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        return WorldStructureGenerator.getTargetY(world, x, z, true) + 1;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        int minY = this.getMinY(template, bb);
        int maxY = this.getMaxY(template, bb);
        return this.validateBorderBlocks(world, template, bb, minY, maxY, true);
    }

    @Override
    public void preGeneration(World world, BlockPosition pos, int face, StructureTemplate template, StructureBB bb) {
        this.prePlacementBorder(world, template, bb);
        this.prePlacementUnderfill(world, template, bb);
    }

    @Override
    public void handleClearAction(World world, int x, int y, int z, StructureTemplate template, StructureBB bb) {
        world.func_147449_b(x, y, z, Blocks.field_150355_j);
    }
}

