/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.load;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateParser;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateParser;

public class TemplateLoader {
    public static final String defaultTemplateDirectory = "/assets/ancientwarfare/templates/";
    public static String outputDirectory = null;
    public static String includeDirectory = null;
    private final String defaultTemplatePackLocation = "/assets/ancientwarfare/template/default_structure_pack.zip";
    private List<File> probableTownFiles = new ArrayList<File>();
    private List<File> probableStructureFiles = new ArrayList<File>();
    private List<File> probableZipFiles = new ArrayList<File>();
    private List<TownTemplate> parsedTownTemplates = new ArrayList<TownTemplate>();
    private Set<String> loadedStructureNames = new HashSet<String>();
    private HashMap<String, BufferedImage> images = new HashMap();
    public static final TemplateLoader INSTANCE = new TemplateLoader();

    private TemplateLoader() {
    }

    public void initializeAndExportDefaults(String path) {
        outputDirectory = "config/ancientwarfare/structures/export/";
        includeDirectory = "config/ancientwarfare/structures/included/";
        File existTest = new File(outputDirectory);
        if (!existTest.exists()) {
            AWLog.log("Creating default Export Directory");
            existTest.mkdirs();
        }
        if (!(existTest = new File(includeDirectory)).exists()) {
            AWLog.log("Creating default Include Directory");
            existTest.mkdirs();
        }
    }

    public void loadTemplates() {
        int loadedCount = this.loadDefaultPack();
        this.locateStructureFiles();
        for (File f : this.probableStructureFiles) {
            StructureTemplate template = this.loadTemplateFromFile(f);
            if (template == null) continue;
            AWLog.log("Loaded Structure Template: [" + template.name + "] WorldGen: " + template.getValidationSettings().isWorldGenEnabled() + "  Survival: " + template.getValidationSettings().isSurvival());
            StructureTemplateManager.INSTANCE.addTemplate(template);
            this.loadedStructureNames.add(template.name);
            ++loadedCount;
        }
        AWLog.log("Loaded " + (loadedCount += this.loadTemplatesFromZips()) + " structure(s)");
        this.validateAndLoadImages();
        this.probableStructureFiles.clear();
        this.probableZipFiles.clear();
        this.loadedStructureNames.clear();
        this.images.clear();
        this.loadTownTemplates();
    }

    private void loadTownTemplates() {
        for (File f : this.probableTownFiles) {
            TownTemplate townTemplate = this.loadTownTemplateFromFile(f);
            if (townTemplate == null) continue;
            this.parsedTownTemplates.add(townTemplate);
        }
        this.probableTownFiles.clear();
        if (!this.parsedTownTemplates.isEmpty()) {
            AWLog.log("Loading Town Templates: ");
            for (TownTemplate t : this.parsedTownTemplates) {
                AWLog.log("Loading town template: " + t.getTownTypeName());
                t.validateStructureEntries();
                TownTemplateManager.INSTANCE.loadTemplate(t);
            }
            AWLog.log("Loaded : " + this.parsedTownTemplates.size() + " Town Templates.");
        }
    }

    private void validateAndLoadImages() {
        String name;
        Iterator<String> it = this.images.keySet().iterator();
        while (it.hasNext() && (name = it.next()) != null) {
            if (!this.loadedStructureNames.contains(name.substring(0, name.length() - 4))) {
                it.remove();
                continue;
            }
            StructureTemplateManager.INSTANCE.addTemplateImage(name, this.images.get(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructureTemplate loadTemplateFromFile(File file) {
        FileReader reader = null;
        Scanner scan = null;
        ArrayList<String> templateLines = new ArrayList<String>();
        try {
            reader = new FileReader(file);
            scan = new Scanner(reader);
            while (scan.hasNext()) {
                templateLines.add(scan.nextLine());
            }
            StructureTemplate structureTemplate = TemplateParser.INSTANCE.parseTemplate(file.getName(), templateLines);
            return structureTemplate;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            StructureTemplate structureTemplate = null;
            return structureTemplate;
        }
        finally {
            if (scan != null) {
                scan.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TownTemplate loadTownTemplateFromFile(File file) {
        FileReader reader = null;
        Scanner scan = null;
        ArrayList<String> templateLines = new ArrayList<String>();
        try {
            reader = new FileReader(file);
            scan = new Scanner(reader);
            while (scan.hasNext()) {
                String line = scan.nextLine();
                if (line.startsWith("#")) continue;
                templateLines.add(line);
            }
            TownTemplate townTemplate = TownTemplateParser.parseTemplate(templateLines);
            return townTemplate;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            TownTemplate townTemplate = null;
            return townTemplate;
        }
        finally {
            if (scan != null) {
                scan.close();
            }
        }
    }

    private void loadStructureImage(String imageName, InputStream is) {
        while (imageName.contains("/")) {
            imageName = imageName.substring(imageName.indexOf("/") + 1, imageName.length());
        }
        try {
            BufferedImage image = ImageIO.read(is);
            if (image != null && image.getWidth() == AWStructureStatics.structureImageWidth && image.getHeight() == AWStructureStatics.structureImageHeight) {
                this.images.put(imageName, image);
                AWLog.logDebug("loaded structure image of: " + imageName);
            } else {
                AWLog.logError("Attempted to load improper sized template image: " + imageName + " with dimensions of: " + image.getWidth() + "x" + image.getHeight() + ".  Specified width/height is: " + AWStructureStatics.structureImageWidth + "x" + AWStructureStatics.structureImageHeight);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int loadTemplatesFromZipStream(ZipInputStream zis) {
        int parsed = 0;
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                StructureTemplate template;
                if (entry.isDirectory()) continue;
                AWLog.logDebug("parsing entry: " + entry.getName());
                if (entry.getName().toLowerCase(Locale.ENGLISH).endsWith(".png")) {
                    this.loadStructureImage(entry.getName(), zis);
                    continue;
                }
                if (entry.getName().toLowerCase(Locale.ENGLISH).endsWith("." + AWStructureStatics.townTemplateExtension)) {
                    this.loadTownTemplateFromZip(entry, zis);
                    continue;
                }
                if (!entry.getName().toLowerCase(Locale.ENGLISH).endsWith("." + AWStructureStatics.templateExtension) || (template = this.loadTemplateFromZip(entry, zis)) == null) continue;
                AWLog.log("Loaded Structure Template: [" + template.name + "] WorldGen: " + template.getValidationSettings().isWorldGenEnabled() + "  Survival: " + template.getValidationSettings().isSurvival());
                StructureTemplateManager.INSTANCE.addTemplate(template);
                this.loadedStructureNames.add(template.name);
                ++parsed;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return parsed;
    }

    private int loadDefaultPack() {
        if (!AWStructureStatics.loadDefaultPack) {
            return 0;
        }
        InputStream is = this.getClass().getResourceAsStream("/assets/ancientwarfare/template/default_structure_pack.zip");
        ZipInputStream zis = new ZipInputStream(is);
        int loaded = this.loadTemplatesFromZipStream(zis);
        try {
            zis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return loaded;
    }

    private int loadTemplatesFromZips() {
        ZipInputStream zis = null;
        FileInputStream fis = null;
        int parsed = 0;
        int totalParsed = 0;
        for (File f : this.probableZipFiles) {
            parsed = 0;
            AWLog.log("Loading templates from zip file: " + f.getName());
            try {
                fis = new FileInputStream(f);
                zis = new ZipInputStream(fis);
                parsed = this.loadTemplatesFromZipStream(zis);
                try {
                    zis.close();
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            AWLog.log("Loaded a total of " + parsed + " template(s) from zip file: " + f.getName());
            totalParsed += parsed;
        }
        return totalParsed;
    }

    private TownTemplate loadTownTemplateFromZip(ZipEntry entry, InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isr);
        ArrayList<String> lines = new ArrayList<String>();
        TownTemplate template = null;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            template = TownTemplateParser.parseTemplate(lines);
            if (template != null) {
                this.parsedTownTemplates.add(template);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            template = null;
        }
        return template;
    }

    private StructureTemplate loadTemplateFromZip(ZipEntry entry, InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isr);
        ArrayList<String> lines = new ArrayList<String>();
        StructureTemplate template = null;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            template = TemplateParser.INSTANCE.parseTemplate(entry.getName(), lines);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            template = null;
        }
        return template;
    }

    private void locateStructureFiles() {
        this.recursiveScan(new File(includeDirectory), this.probableStructureFiles, this.probableZipFiles, AWStructureStatics.templateExtension);
        this.recursiveScan(new File(includeDirectory), this.probableTownFiles, this.probableZipFiles, AWStructureStatics.townTemplateExtension);
    }

    private void recursiveScan(File directory, List<File> fileList, List<File> zipFileList, String extension) {
        if (directory == null) {
            AWLog.logError("Could not locate " + directory + " directory to load structures!");
            return;
        }
        File[] allFiles = directory.listFiles();
        if (allFiles == null) {
            AWLog.logError("Could not locate " + directory + " directory to load structures!--no files in directory file list!");
            return;
        }
        for (int i = 0; i < allFiles.length; ++i) {
            File currentFile = allFiles[i];
            if (currentFile.isDirectory()) {
                this.recursiveScan(currentFile, fileList, zipFileList, extension);
                continue;
            }
            if (this.isProbableFile(currentFile, extension) && !fileList.contains(currentFile)) {
                fileList.add(currentFile);
                continue;
            }
            if (this.isProbableZip(currentFile) && !zipFileList.contains(currentFile)) {
                zipFileList.add(currentFile);
                continue;
            }
            if (!this.isProbableImage(currentFile)) continue;
            try {
                FileInputStream fis = new FileInputStream(currentFile);
                this.loadStructureImage(currentFile.getName(), fis);
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isProbableFile(File file, String extension) {
        return file.getName().toLowerCase(Locale.ENGLISH).endsWith(extension);
    }

    private boolean isProbableZip(File file) {
        return this.isProbableFile(file, ".zip");
    }

    private boolean isProbableImage(File file) {
        return this.isProbableFile(file, ".png");
    }
}

