/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.NBTTools;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules.TemplateRuleVanillaBlocks;

public class TemplateRuleBlockInventory
extends TemplateRuleVanillaBlocks {
    public int randomLootLevel = 0;
    public NBTTagCompound tag = new NBTTagCompound();
    ItemStack[] inventoryStacks;

    public TemplateRuleBlockInventory(World world, int x, int y, int z, Block block, int meta, int turns) {
        super(world, x, y, z, block, meta, turns);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            int i;
            boolean useKey;
            IInventory inventory = (IInventory)te;
            if (inventory.func_70302_i_() <= 0) {
                return;
            }
            ItemStack keyStack = inventory.func_70301_a(0);
            boolean bl = useKey = keyStack != null && (keyStack.func_77973_b() == Items.field_151043_k || keyStack.func_77973_b() == Items.field_151045_i || keyStack.func_77973_b() == Items.field_151166_bC);
            if (useKey) {
                for (int i2 = 1; i2 < inventory.func_70302_i_(); ++i2) {
                    if (inventory.func_70301_a(i2) == null) continue;
                    useKey = false;
                    break;
                }
            }
            this.randomLootLevel = useKey ? (keyStack.func_77973_b() == Items.field_151043_k ? 1 : (keyStack.func_77973_b() == Items.field_151045_i ? 2 : 3)) : 0;
            this.inventoryStacks = new ItemStack[inventory.func_70302_i_()];
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                inventory.func_70299_a(i, null);
                this.inventoryStacks[i] = stack == null ? null : stack.func_77946_l();
            }
            te.func_145841_b(this.tag);
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                inventory.func_70299_a(i, this.inventoryStacks[i]);
            }
            this.tag.func_82580_o("Items");
        }
    }

    public TemplateRuleBlockInventory() {
    }

    @Override
    public void handlePlacement(World world, int turns, int x, int y, int z, IStructureBuilder builder) {
        super.handlePlacement(world, turns, x, y, z, builder);
        int localMeta = BlockDataManager.INSTANCE.getRotatedMeta(this.block, this.meta, turns);
        world.func_72921_c(x, y, z, localMeta, 3);
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)te;
        this.tag.func_74768_a("x", x);
        this.tag.func_74768_a("y", y);
        this.tag.func_74768_a("z", z);
        te.func_145839_a(this.tag);
        if (this.randomLootLevel > 0) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                inventory.func_70299_a(i, null);
            }
            this.generateLootFor(inventory, world.field_73012_v);
        } else if (this.inventoryStacks != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = i < this.inventoryStacks.length ? this.inventoryStacks[i] : null;
                inventory.func_70299_a(i, stack == null ? null : stack.func_77946_l());
            }
        }
        world.func_147471_g(x, y, z);
    }

    public void generateLootFor(IInventory inventory, Random rng) {
        for (int i = 0; i < this.randomLootLevel; ++i) {
            WeightedRandomChestContent.func_76293_a((Random)rng, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"dungeonChest", (Random)rng), (IInventory)inventory, (int)ChestGenHooks.getCount((String)"dungeonChest", (Random)rng));
        }
    }

    @Override
    public boolean shouldReuseRule(World world, Block block, int meta, int turns, int x, int y, int z) {
        return false;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74768_a("lootLevel", this.randomLootLevel);
        tag.func_74782_a("teData", (NBTBase)this.tag);
        NBTTagCompound invData = new NBTTagCompound();
        invData.func_74768_a("length", this.inventoryStacks.length);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            ItemStack stack = this.inventoryStacks[i];
            if (stack == null) continue;
            NBTTagCompound itemTag = NBTTools.writeItemStack(stack, new NBTTagCompound());
            itemTag.func_74768_a("slot", i);
            list.func_74742_a((NBTBase)itemTag);
        }
        invData.func_74782_a("inventoryContents", (NBTBase)list);
        tag.func_74782_a("inventoryData", (NBTBase)invData);
    }

    @Override
    public void parseRuleData(NBTTagCompound tag) {
        super.parseRuleData(tag);
        if (tag.func_74764_b("inventoryData")) {
            NBTTagCompound inventoryTag = tag.func_74775_l("inventoryData");
            int length = inventoryTag.func_74762_e("length");
            this.inventoryStacks = new ItemStack[length];
            NBTTagList list = inventoryTag.func_150295_c("inventoryContents", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                ItemStack stack = NBTTools.readItemStack(itemTag);
                if (stack == null) continue;
                int slot = itemTag.func_74762_e("slot");
                this.inventoryStacks[slot] = stack;
            }
        }
        this.randomLootLevel = tag.func_74762_e("lootLevel");
        this.tag = tag.func_74775_l("teData");
    }
}

