/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IBoundedSite;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;

public class TemplateRuleRotable
extends TemplateRuleBlock {
    public String blockName;
    public int meta;
    public int orientation;
    BlockPosition p1;
    BlockPosition p2;
    NBTTagCompound tag;

    public TemplateRuleRotable(World world, int x, int y, int z, Block block, int meta, int turns) {
        super(world, x, y, z, block, meta, turns);
        this.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
        this.meta = meta;
        TileEntity worksite = world.func_147438_o(x, y, z);
        ForgeDirection o = ((BlockRotationHandler.IRotatableTile)worksite).getPrimaryFacing();
        for (int i = 0; i < turns; ++i) {
            o = o.getRotation(ForgeDirection.UP);
        }
        this.orientation = o.ordinal();
        if (worksite instanceof IBoundedSite && ((IBoundedSite)worksite).hasWorkBounds()) {
            this.p1 = BlockTools.rotateAroundOrigin(((IBoundedSite)worksite).getWorkBoundsMin().offset(-x, -y, -z), turns);
            this.p2 = BlockTools.rotateAroundOrigin(((IBoundedSite)worksite).getWorkBoundsMax().offset(-x, -y, -z), turns);
        }
        this.tag = new NBTTagCompound();
        worksite.func_145841_b(this.tag);
    }

    public TemplateRuleRotable() {
    }

    @Override
    public boolean shouldReuseRule(World world, Block block, int meta, int turns, int x, int y, int z) {
        return false;
    }

    @Override
    public void handlePlacement(World world, int turns, int x, int y, int z, IStructureBuilder builder) {
        TileEntity worksite;
        Block block = BlockDataManager.INSTANCE.getBlockForName(this.blockName);
        if (world.func_147465_d(x, y, z, block, this.meta, 2) && (worksite = world.func_147438_o(x, y, z)) != null) {
            this.tag.func_74768_a("x", x);
            this.tag.func_74768_a("y", y);
            this.tag.func_74768_a("z", z);
            worksite.func_145839_a(this.tag);
            ForgeDirection o = ForgeDirection.getOrientation((int)this.orientation);
            for (int i = 0; i < turns; ++i) {
                o = o.getRotation(ForgeDirection.UP);
            }
            ((BlockRotationHandler.IRotatableTile)worksite).setPrimaryFacing(o);
            if (worksite instanceof IBoundedSite && this.p1 != null && this.p2 != null) {
                BlockPosition pos1 = BlockTools.rotateAroundOrigin(this.p1, turns).offset(x, y, z);
                BlockPosition pos2 = BlockTools.rotateAroundOrigin(this.p2, turns).offset(x, y, z);
                ((IBoundedSite)worksite).setBounds(pos1, pos2);
            }
            world.func_147471_g(x, y, z);
        }
    }

    @Override
    public void parseRuleData(NBTTagCompound tag) {
        this.blockName = tag.func_74779_i("blockId");
        this.meta = tag.func_74762_e("meta");
        this.orientation = tag.func_74762_e("orientation");
        if (tag.func_74764_b("teData")) {
            this.tag = tag.func_74775_l("teData");
        }
        if (tag.func_74764_b("pos1")) {
            this.p1 = new BlockPosition(tag.func_74775_l("pos1"));
        }
        if (tag.func_74764_b("pos2")) {
            this.p2 = new BlockPosition(tag.func_74775_l("pos2"));
        }
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        tag.func_74778_a("blockId", this.blockName);
        tag.func_74768_a("meta", this.meta);
        tag.func_74768_a("orientation", this.orientation);
        if (this.p1 != null) {
            tag.func_74782_a("pos1", (NBTBase)this.p1.writeToNBT(new NBTTagCompound()));
        }
        if (this.p2 != null) {
            tag.func_74782_a("pos2", (NBTBase)this.p2.writeToNBT(new NBTTagCompound()));
        }
        if (this.tag != null) {
            tag.func_74782_a("teData", (NBTBase)this.tag);
        }
    }

    @Override
    public void addResources(List<ItemStack> resources) {
        resources.add(new ItemStack(Item.func_150898_a((Block)BlockDataManager.INSTANCE.getBlockForName(this.blockName)), 1, this.meta));
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, int x, int y, int z, int buildPass) {
        return buildPass == 0;
    }
}

