/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.block_rules;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;

public class TemplateRuleVanillaBlocks
extends TemplateRuleBlock {
    public String blockName;
    public Block block;
    public int meta;
    public int buildPass = 0;

    public TemplateRuleVanillaBlocks(World world, int x, int y, int z, Block block, int meta, int turns) {
        super(world, x, y, z, block, meta, turns);
        this.blockName = BlockDataManager.INSTANCE.getNameForBlock(block);
        this.block = block;
        this.meta = BlockDataManager.INSTANCE.getRotatedMeta(block, meta, turns);
        this.buildPass = BlockDataManager.INSTANCE.getPriorityForBlock(block);
    }

    public TemplateRuleVanillaBlocks() {
    }

    @Override
    public void handlePlacement(World world, int turns, int x, int y, int z, IStructureBuilder builder) {
        int localMeta = BlockDataManager.INSTANCE.getRotatedMeta(this.block, this.meta, turns);
        builder.placeBlock(x, y, z, this.block, localMeta, this.buildPass);
    }

    @Override
    public boolean shouldReuseRule(World world, Block block, int meta, int turns, int x, int y, int z) {
        return block != null && block == this.block && BlockDataManager.INSTANCE.getRotatedMeta(block, meta, turns) == this.meta;
    }

    @Override
    public void addResources(List<ItemStack> resources) {
        if (this.block == null || this.block == Blocks.field_150350_a) {
            return;
        }
        ItemStack stack = BlockDataManager.INSTANCE.getInventoryStackForBlock(this.block, this.meta);
        if (stack != null && stack.func_77973_b() == null) {
            throw new IllegalArgumentException("Could not create item for block: " + this.block + " (lookup name: " + this.blockName + ") meta: " + this.meta);
        }
        if (stack != null) {
            resources.add(stack);
        }
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, int x, int y, int z, int buildPass) {
        return buildPass == this.buildPass;
    }

    @Override
    public String toString() {
        return String.format("Vanilla Block Rule id: %s meta: %s buildPass: %s", this.blockName, this.meta, this.buildPass);
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        tag.func_74778_a("blockName", this.blockName);
        tag.func_74768_a("meta", this.meta);
        tag.func_74768_a("buildPass", this.buildPass);
    }

    @Override
    public void parseRuleData(NBTTagCompound tag) {
        this.blockName = tag.func_74779_i("blockName");
        this.block = BlockDataManager.INSTANCE.getBlockForName(this.blockName);
        this.meta = tag.func_74762_e("meta");
        this.buildPass = tag.func_74762_e("buildPass");
    }
}

