/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.entity_rules;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.NBTTools;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuildingException;
import net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.entity_rules.TemplateRuleVanillaEntity;

public class TemplateRuleEntityLogic
extends TemplateRuleVanillaEntity {
    public NBTTagCompound tag = new NBTTagCompound();
    ItemStack[] inventory;
    ItemStack[] equipment;

    public TemplateRuleEntityLogic() {
    }

    public TemplateRuleEntityLogic(World world, Entity entity, int turns, int x, int y, int z) {
        super(world, entity, turns, x, y, z);
        int i;
        entity.func_70109_d(this.tag);
        if (entity instanceof EntityLiving) {
            this.tag.func_82580_o("Equipment");
            this.equipment = new ItemStack[5];
            EntityLiving living = (EntityLiving)entity;
            for (i = 0; i < 5; ++i) {
                this.equipment[i] = living.func_71124_b(i) == null ? null : living.func_71124_b(i).func_77946_l();
            }
        }
        if (entity instanceof IInventory) {
            this.tag.func_82580_o("Items");
            IInventory eInv = (IInventory)entity;
            this.inventory = new ItemStack[eInv.func_70302_i_()];
            for (i = 0; i < eInv.func_70302_i_(); ++i) {
                this.inventory[i] = eInv.func_70301_a(i) == null ? null : eInv.func_70301_a(i).func_77946_l();
            }
        }
        this.tag.func_82580_o("UUIDMost");
        this.tag.func_82580_o("UUIDLeast");
    }

    @Override
    public void handlePlacement(World world, int turns, int x, int y, int z, IStructureBuilder builder) throws StructureBuildingException.EntityPlacementException {
        Entity e = this.createEntity(world, turns, x, y, z, builder);
        world.func_72838_d(e);
    }

    protected Entity createEntity(World world, int turns, int x, int y, int z, IStructureBuilder builder) throws StructureBuildingException.EntityPlacementException {
        int i;
        Entity e = EntityList.func_75620_a((String)this.mobID, (World)world);
        if (e == null) {
            throw new StructureBuildingException.EntityPlacementException("Could not create entity for name: " + this.mobID + " Entity skipped during structure creation.\n" + "Entity data: " + this.tag);
        }
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagDouble((double)((float)x + BlockTools.rotateFloatX(this.xOffset, this.zOffset, turns))));
        list.func_74742_a((NBTBase)new NBTTagDouble((double)y));
        list.func_74742_a((NBTBase)new NBTTagDouble((double)((float)z + BlockTools.rotateFloatZ(this.xOffset, this.zOffset, turns))));
        this.tag.func_74782_a("Pos", (NBTBase)list);
        e.func_70020_e(this.tag);
        if (this.equipment != null && e instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)e;
            for (i = 0; i < 5; ++i) {
                living.func_70062_b(i, this.equipment[i] == null ? null : this.equipment[i].func_77946_l());
            }
        }
        if (this.inventory != null && e instanceof IInventory) {
            IInventory eInv = (IInventory)e;
            for (i = 0; i < this.inventory.length && i < eInv.func_70302_i_(); ++i) {
                eInv.func_70299_a(i, this.inventory[i] == null ? null : this.inventory[i].func_77946_l());
            }
        }
        e.field_70177_z = (this.rotation + 90.0f * (float)turns) % 360.0f;
        return e;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        NBTTagCompound itemTag;
        ItemStack stack;
        int i;
        NBTTagList list;
        NBTTagCompound invData;
        super.writeRuleData(tag);
        tag.func_74782_a("entityData", (NBTBase)this.tag);
        if (this.inventory != null) {
            invData = new NBTTagCompound();
            invData.func_74768_a("length", this.inventory.length);
            list = new NBTTagList();
            for (i = 0; i < this.inventory.length; ++i) {
                stack = this.inventory[i];
                if (stack == null) continue;
                itemTag = NBTTools.writeItemStack(stack, new NBTTagCompound());
                itemTag.func_74768_a("slot", i);
                list.func_74742_a((NBTBase)itemTag);
            }
            invData.func_74782_a("inventoryContents", (NBTBase)list);
            tag.func_74782_a("inventoryData", (NBTBase)invData);
        }
        if (this.equipment != null) {
            invData = new NBTTagCompound();
            invData.func_74768_a("length", this.equipment.length);
            list = new NBTTagList();
            for (i = 0; i < this.equipment.length; ++i) {
                stack = this.equipment[i];
                if (stack == null) continue;
                itemTag = NBTTools.writeItemStack(stack, new NBTTagCompound());
                itemTag.func_74768_a("slot", i);
                list.func_74742_a((NBTBase)itemTag);
            }
            invData.func_74782_a("equipmentContents", (NBTBase)list);
            tag.func_74782_a("equipmentData", (NBTBase)invData);
        }
    }

    @Override
    public void parseRuleData(NBTTagCompound tag) {
        int slot;
        ItemStack stack;
        NBTTagCompound itemTag;
        int i;
        NBTTagList list;
        int length;
        NBTTagCompound inventoryTag;
        super.parseRuleData(tag);
        this.tag = tag.func_74775_l("entityData");
        if (tag.func_74764_b("inventoryData")) {
            inventoryTag = tag.func_74775_l("inventoryData");
            length = inventoryTag.func_74762_e("length");
            this.inventory = new ItemStack[length];
            list = tag.func_150295_c("inventoryContents", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                itemTag = list.func_150305_b(i);
                stack = NBTTools.readItemStack(itemTag);
                if (stack == null) continue;
                slot = itemTag.func_74762_e("slot");
                this.inventory[slot] = stack;
            }
        }
        if (tag.func_74764_b("equipmentData")) {
            inventoryTag = tag.func_74775_l("equipmentData");
            length = inventoryTag.func_74762_e("length");
            this.equipment = new ItemStack[length];
            list = inventoryTag.func_150295_c("equipmentContents", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                itemTag = list.func_150305_b(i);
                stack = NBTTools.readItemStack(itemTag);
                if (stack == null) continue;
                slot = itemTag.func_74762_e("slot");
                this.equipment[slot] = stack;
            }
        }
    }
}

