/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.entity_rules;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuildingException;

public class TemplateRuleGates
extends TemplateRuleEntity {
    String gateType;
    int orientation;
    BlockPosition pos1 = new BlockPosition();
    BlockPosition pos2 = new BlockPosition();

    public TemplateRuleGates(World world, Entity entity, int turns, int x, int y, int z) {
        super(world, entity, turns, x, y, z);
        EntityGate gate = (EntityGate)entity;
        this.pos1 = BlockTools.rotateAroundOrigin(gate.pos1.offset(-x, -y, -z), turns);
        this.pos2 = BlockTools.rotateAroundOrigin(gate.pos2.offset(-x, -y, -z), turns);
        this.orientation = (gate.gateOrientation + turns) % 4;
        this.gateType = Gate.getGateNameFor(gate);
    }

    public TemplateRuleGates() {
    }

    @Override
    public void handlePlacement(World world, int turns, int x, int y, int z, IStructureBuilder builder) throws StructureBuildingException.EntityPlacementException {
        BlockPosition p1 = BlockTools.rotateAroundOrigin(this.pos1, turns).offset(x, y, z);
        BlockPosition p2 = BlockTools.rotateAroundOrigin(this.pos2, turns).offset(x, y, z);
        BlockPosition min = BlockTools.getMin(p1, p2);
        BlockPosition max = BlockTools.getMax(p1, p2);
        for (int x1 = min.x; x1 <= max.x; ++x1) {
            for (int y1 = min.y; y1 <= max.y; ++y1) {
                for (int z1 = min.z; z1 <= max.z; ++z1) {
                    world.func_147449_b(x1, y1, z1, Blocks.field_150350_a);
                }
            }
        }
        EntityGate gate = Gate.constructGate(world, p1, p2, Gate.getGateByName(this.gateType), (byte)((this.orientation + turns) % 4));
        if (gate == null) {
            throw new StructureBuildingException.EntityPlacementException("Could not create gate for type: " + this.gateType);
        }
        world.func_72838_d((Entity)gate);
    }

    @Override
    public void parseRuleData(NBTTagCompound tag) {
        this.gateType = tag.func_74779_i("gateType");
        this.orientation = tag.func_74771_c("orientation");
        this.pos1 = new BlockPosition(tag.func_74775_l("pos1"));
        this.pos2 = new BlockPosition(tag.func_74775_l("pos2"));
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        tag.func_74778_a("gateType", this.gateType);
        tag.func_74774_a("orientation", (byte)this.orientation);
        tag.func_74782_a("pos1", (NBTBase)this.pos1.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("pos2", (NBTBase)this.pos2.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void addResources(List<ItemStack> resources) {
        resources.add(Gate.getItemToConstruct(Gate.getGateByName(this.gateType).getGlobalID()));
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, int x, int y, int z, int buildPass) {
        return buildPass == 3;
    }
}

