/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.default_plugins.entity_rules;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuildingException;

public class TemplateRuleVanillaEntity
extends TemplateRuleEntity {
    public String mobID;
    public float xOffset;
    public float zOffset;
    public float rotation;

    public TemplateRuleVanillaEntity(World world, Entity entity, int turns, int x, int y, int z) {
        this.mobID = EntityList.func_75621_b((Entity)entity);
        this.rotation = (entity.field_70177_z + 90.0f * (float)turns) % 360.0f;
        float x1 = (float)(entity.field_70165_t % 1.0);
        float z1 = (float)(entity.field_70161_v % 1.0);
        if (x1 < 0.0f) {
            x1 += 1.0f;
        }
        if (z1 < 0.0f) {
            z1 += 1.0f;
        }
        this.xOffset = BlockTools.rotateFloatX(x1, z1, turns);
        this.zOffset = BlockTools.rotateFloatZ(x1, z1, turns);
    }

    public TemplateRuleVanillaEntity() {
    }

    @Override
    public void handlePlacement(World world, int turns, int x, int y, int z, IStructureBuilder builder) throws StructureBuildingException.EntityPlacementException {
        Entity e = EntityList.func_75620_a((String)this.mobID, (World)world);
        if (e == null) {
            throw new StructureBuildingException.EntityPlacementException("Could not create entity for type: " + this.mobID);
        }
        float x1 = BlockTools.rotateFloatX(this.xOffset, this.zOffset, turns);
        float z1 = BlockTools.rotateFloatZ(this.xOffset, this.zOffset, turns);
        float yaw = (this.rotation + 90.0f * (float)turns) % 360.0f;
        e.func_70107_b((double)((float)x + x1), (double)y, (double)((float)z + z1));
        e.field_70177_z = yaw;
        world.func_72838_d(e);
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        tag.func_74778_a("mobID", this.mobID);
        tag.func_74776_a("xOffset", this.xOffset);
        tag.func_74776_a("zOffset", this.zOffset);
        tag.func_74776_a("rotation", this.rotation);
    }

    @Override
    public void parseRuleData(NBTTagCompound tag) {
        this.mobID = tag.func_74779_i("mobID");
        this.xOffset = tag.func_74760_g("xOffset");
        this.zOffset = tag.func_74760_g("zOffset");
        this.rotation = tag.func_74760_g("rotation");
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, int x, int y, int z, int buildPass) {
        return buildPass == 3;
    }

    @Override
    public void addResources(List<ItemStack> resources) {
    }
}

