/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.api.AWBlocks;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.entity.WatchedData;
import net.shadowmage.ancientwarfare.core.inventory.InventoryBasic;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;

public class SpawnerSettings {
    List<EntitySpawnGroup> spawnGroups = new ArrayList<EntitySpawnGroup>();
    private InventoryBasic inventory = new InventoryBasic(9);
    boolean debugMode;
    boolean transparent;
    boolean respondToRedstone;
    boolean redstoneMode;
    boolean prevRedstoneState;
    int playerRange;
    int mobRange;
    int range = 4;
    int maxDelay = 400;
    int minDelay = 200;
    int spawnDelay = this.maxDelay;
    int maxNearbyMonsters;
    boolean lightSensitive;
    int xpToDrop;
    float blockHardness = 2.0f;
    public World worldObj;
    int xCoord;
    int yCoord;
    int zCoord;

    public static SpawnerSettings getDefaultSettings() {
        SpawnerSettings settings = new SpawnerSettings();
        settings.playerRange = 16;
        settings.mobRange = 4;
        settings.maxNearbyMonsters = 8;
        EntitySpawnGroup group = new EntitySpawnGroup();
        group.addSpawnSetting(new EntitySpawnSettings());
        settings.addSpawnGroup(group);
        return settings;
    }

    public void setWorld(World world, int x, int y, int z) {
        this.worldObj = world;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public void onUpdate() {
        if (!this.respondToRedstone) {
            this.updateNormalMode();
        } else if (this.redstoneMode) {
            this.updateRedstoneModePulse();
        } else {
            this.updateRedstoneModeToggle();
        }
        if (this.spawnGroups.isEmpty()) {
            this.worldObj.func_147468_f(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    private void updateRedstoneModeToggle() {
        boolean bl = this.prevRedstoneState = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord) || this.worldObj.func_94577_B(this.xCoord, this.yCoord, this.zCoord) > 0;
        if (this.respondToRedstone && !this.redstoneMode && !this.prevRedstoneState) {
            return;
        }
        this.updateNormalMode();
    }

    private void updateRedstoneModePulse() {
        boolean powered;
        boolean bl = powered = this.worldObj.func_72864_z(this.xCoord, this.yCoord, this.zCoord) || this.worldObj.func_94577_B(this.xCoord, this.yCoord, this.zCoord) > 0;
        if (!this.prevRedstoneState && powered) {
            this.spawnEntities();
        }
        this.prevRedstoneState = powered;
    }

    private void updateNormalMode() {
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        }
        if (this.spawnDelay <= 0) {
            int range = this.maxDelay - this.minDelay;
            this.spawnDelay = this.minDelay + (range <= 0 ? 0 : this.worldObj.field_73012_v.nextInt(range));
            this.spawnEntities();
        }
    }

    private void spawnEntities() {
        int nearbyCount;
        int light;
        if (this.lightSensitive && (light = this.worldObj.func_72957_l(this.xCoord, this.yCoord, this.zCoord)) >= 8) {
            return;
        }
        if (this.playerRange > 0) {
            List nearbyPlayers = this.worldObj.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).func_72314_b((double)this.playerRange, (double)this.playerRange, (double)this.playerRange));
            if (nearbyPlayers.isEmpty()) {
                return;
            }
            boolean doSpawn = false;
            for (EntityPlayer player : nearbyPlayers) {
                if (!this.debugMode && player.field_71075_bZ.field_75098_d) continue;
                doSpawn = true;
                break;
            }
            if (!doSpawn) {
                return;
            }
        }
        if (this.maxNearbyMonsters > 0 && this.mobRange > 0 && (nearbyCount = this.worldObj.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).func_72314_b((double)this.mobRange, (double)this.mobRange, (double)this.mobRange)).size()) >= this.maxNearbyMonsters) {
            AWLog.logDebug("skipping spawning because of too many nearby entities");
            return;
        }
        int totalWeight = 0;
        for (EntitySpawnGroup group : this.spawnGroups) {
            totalWeight += group.groupWeight;
        }
        int rand = totalWeight == 0 ? 0 : this.worldObj.field_73012_v.nextInt(totalWeight);
        int check = 0;
        EntitySpawnGroup toSpawn = null;
        int index = 0;
        for (EntitySpawnGroup group : this.spawnGroups) {
            if (rand < (check += group.groupWeight)) {
                toSpawn = group;
                break;
            }
            ++index;
        }
        if (toSpawn != null) {
            toSpawn.spawnEntities(this.worldObj, this.xCoord, this.yCoord, this.zCoord, index, this.range);
            if (toSpawn.shouldRemove()) {
                this.spawnGroups.remove(toSpawn);
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("respondToRedstone", this.respondToRedstone);
        if (this.respondToRedstone) {
            tag.func_74757_a("redstoneMode", this.redstoneMode);
            tag.func_74757_a("prevRedstoneState", this.prevRedstoneState);
        }
        tag.func_74768_a("minDelay", this.minDelay);
        tag.func_74768_a("maxDelay", this.maxDelay);
        tag.func_74768_a("spawnDelay", this.spawnDelay);
        tag.func_74768_a("playerRange", this.playerRange);
        tag.func_74768_a("mobRange", this.mobRange);
        tag.func_74768_a("spawnRange", this.range);
        tag.func_74768_a("maxNearbyMonsters", this.maxNearbyMonsters);
        tag.func_74768_a("xpToDrop", this.xpToDrop);
        tag.func_74757_a("lightSensitive", this.lightSensitive);
        tag.func_74757_a("transparent", this.transparent);
        tag.func_74757_a("debugMode", this.debugMode);
        NBTTagList groupList = new NBTTagList();
        for (EntitySpawnGroup group : this.spawnGroups) {
            NBTTagCompound groupTag = new NBTTagCompound();
            group.writeToNBT(groupTag);
            groupList.func_74742_a((NBTBase)groupTag);
        }
        tag.func_74782_a("spawnGroups", (NBTBase)groupList);
        NBTTagCompound invTag = new NBTTagCompound();
        this.inventory.writeToNBT(invTag);
        tag.func_74782_a("inventory", (NBTBase)invTag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.spawnGroups.clear();
        this.respondToRedstone = tag.func_74767_n("respondToRedstone");
        if (this.respondToRedstone) {
            this.redstoneMode = tag.func_74767_n("redstoneMode");
            this.prevRedstoneState = tag.func_74767_n("prevRedstoneState");
        }
        this.minDelay = tag.func_74762_e("minDelay");
        this.maxDelay = tag.func_74762_e("maxDelay");
        this.spawnDelay = tag.func_74762_e("spawnDelay");
        this.playerRange = tag.func_74762_e("playerRange");
        this.mobRange = tag.func_74762_e("mobRange");
        this.range = tag.func_74762_e("spawnRange");
        this.maxNearbyMonsters = tag.func_74762_e("maxNearbyMonsters");
        this.xpToDrop = tag.func_74762_e("xpToDrop");
        this.lightSensitive = tag.func_74767_n("lightSensitive");
        this.transparent = tag.func_74767_n("transparent");
        this.debugMode = tag.func_74767_n("debugMode");
        NBTTagList groupList = tag.func_150295_c("spawnGroups", 10);
        for (int i = 0; i < groupList.func_74745_c(); ++i) {
            EntitySpawnGroup group = new EntitySpawnGroup();
            group.readFromNBT(groupList.func_150305_b(i));
            this.spawnGroups.add(group);
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
    }

    public void addSpawnGroup(EntitySpawnGroup group) {
        this.spawnGroups.add(group);
    }

    public List<EntitySpawnGroup> getSpawnGroups() {
        return this.spawnGroups;
    }

    public final boolean isLightSensitive() {
        return this.lightSensitive;
    }

    public final void toggleLightSensitive() {
        this.lightSensitive = !this.lightSensitive;
    }

    public final boolean isRespondToRedstone() {
        return this.respondToRedstone;
    }

    public final void toggleRespondToRedstone() {
        this.respondToRedstone = !this.respondToRedstone;
    }

    public final boolean getRedstoneMode() {
        return this.redstoneMode;
    }

    public final void toggleRedstoneMode() {
        this.redstoneMode = !this.redstoneMode;
    }

    public final int getPlayerRange() {
        return this.playerRange;
    }

    public final void setPlayerRange(int playerRange) {
        this.playerRange = playerRange;
    }

    public final int getMobRange() {
        return this.mobRange;
    }

    public final void setMobRange(int mobRange) {
        this.mobRange = mobRange;
    }

    public final int getSpawnRange() {
        return this.range;
    }

    public final void setSpawnRange(int range) {
        this.range = range;
    }

    public final int getMaxDelay() {
        return this.maxDelay;
    }

    public final void setMaxDelay(int maxDelay) {
        if (this.minDelay > maxDelay) {
            this.minDelay = maxDelay;
        }
        this.maxDelay = maxDelay;
    }

    public final int getMinDelay() {
        return this.minDelay;
    }

    public final void setMinDelay(int minDelay) {
        if (minDelay > this.maxDelay) {
            this.maxDelay = minDelay;
        }
        this.minDelay = minDelay;
    }

    public final int getSpawnDelay() {
        return this.spawnDelay;
    }

    public final void setSpawnDelay(int spawnDelay) {
        if (spawnDelay > this.maxDelay) {
            this.maxDelay = spawnDelay;
        }
        if (spawnDelay < this.minDelay) {
            this.minDelay = spawnDelay;
        }
        this.spawnDelay = spawnDelay;
    }

    public final int getMaxNearbyMonsters() {
        return this.maxNearbyMonsters;
    }

    public final void setMaxNearbyMonsters(int maxNearbyMonsters) {
        this.maxNearbyMonsters = maxNearbyMonsters;
    }

    public final void setXpToDrop(int xp) {
        this.xpToDrop = xp;
    }

    public final void setBlockHardness(float hardness) {
        this.blockHardness = hardness;
    }

    public final int getXpToDrop() {
        return this.xpToDrop;
    }

    public final float getBlockHardness() {
        return this.blockHardness;
    }

    public final InventoryBasic getInventory() {
        return this.inventory;
    }

    public final boolean isDebugMode() {
        return this.debugMode;
    }

    public final void toggleDebugMode() {
        this.debugMode = !this.debugMode;
    }

    public final boolean isTransparent() {
        return this.transparent;
    }

    public final void toggleTransparent() {
        this.transparent = !this.transparent;
    }

    public static final class EntitySpawnSettings {
        String entityId = "Pig";
        NBTTagCompound customTag;
        List<WatchedData> customData = new ArrayList<WatchedData>();
        int minToSpawn = 2;
        int maxToSpawn = 4;
        int remainingSpawnCount = -1;
        boolean forced;

        public EntitySpawnSettings() {
        }

        public EntitySpawnSettings(String entityId) {
            this.setEntityToSpawn(entityId);
        }

        public final void writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("entityId", this.entityId);
            if (this.customTag != null) {
                tag.func_74782_a("customTag", (NBTBase)this.customTag);
            }
            tag.func_74757_a("forced", this.forced);
            tag.func_74768_a("minToSpawn", this.minToSpawn);
            tag.func_74768_a("maxToSpawn", this.maxToSpawn);
            tag.func_74768_a("remainingSpawnCount", this.remainingSpawnCount);
            NBTTagList list = new NBTTagList();
            for (WatchedData custom : this.customData) {
                list.func_74742_a((NBTBase)custom.toTag());
            }
            tag.func_74782_a("customData", (NBTBase)list);
        }

        public final void readFromNBT(NBTTagCompound tag) {
            this.setEntityToSpawn(tag.func_74779_i("entityId"));
            if (tag.func_74764_b("customTag")) {
                this.customTag = tag.func_74775_l("customTag");
            }
            this.forced = tag.func_74767_n("forced");
            this.minToSpawn = tag.func_74762_e("minToSpawn");
            this.maxToSpawn = tag.func_74762_e("maxToSpawn");
            this.remainingSpawnCount = tag.func_74762_e("remainingSpawnCount");
            this.customData.clear();
            if (tag.func_74764_b("customData")) {
                NBTTagList list = tag.func_150295_c("customData", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    this.addCustomData(WatchedData.fromTag(list.func_150305_b(i)));
                }
            }
        }

        public final void setEntityToSpawn(String entityId) {
            this.entityId = entityId;
            if (!EntityList.field_75625_b.containsKey(this.entityId)) {
                AWLog.logError(entityId + " is not a valid entityId.  Spawner default to Zombie.");
                this.entityId = "Zombie";
            }
            if (AWStructureStatics.excludedSpawnerEntities.contains(this.entityId)) {
                AWLog.logError(entityId + " has been set as an invalid entity for spawners!  Spawner default to Zombie.");
                this.entityId = "Zombie";
            }
        }

        public final void setCustomSpawnTag(NBTTagCompound tag) {
            this.customTag = tag;
        }

        public final void addCustomData(WatchedData data) {
            if (data != null && data.isValid()) {
                Iterator<WatchedData> itr = this.customData.iterator();
                while (itr.hasNext()) {
                    if (!data.collideWith(itr.next())) continue;
                    itr.remove();
                }
                this.customData.add(data);
            }
            Collections.sort(this.customData, WatchedData.IndexSorter.INSTANCE);
        }

        public final List<WatchedData> getCustomData() {
            return this.customData;
        }

        public final void setSpawnCountMin(int min) {
            this.minToSpawn = min;
        }

        public final void setSpawnCountMax(int max) {
            this.maxToSpawn = this.minToSpawn < max ? max : this.minToSpawn;
        }

        public final void setSpawnLimitTotal(int total) {
            this.remainingSpawnCount = total;
        }

        public final void toggleForce() {
            this.forced = !this.forced;
        }

        private boolean shouldRemove() {
            return this.remainingSpawnCount == 0;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final String getEntityName() {
            return "entity." + this.entityId + ".name";
        }

        public final int getSpawnMin() {
            return this.minToSpawn;
        }

        public final int getSpawnMax() {
            return this.maxToSpawn;
        }

        public final int getSpawnTotal() {
            return this.remainingSpawnCount;
        }

        public final boolean isForced() {
            return this.forced;
        }

        public final NBTTagCompound getCustomTag() {
            return this.customTag;
        }

        private int getNumToSpawn(Random rand) {
            int randRange = this.maxToSpawn - this.minToSpawn;
            int toSpawn = 0;
            toSpawn = randRange <= 0 ? this.minToSpawn : this.minToSpawn + rand.nextInt(randRange);
            if (this.remainingSpawnCount >= 0 && toSpawn > this.remainingSpawnCount) {
                toSpawn = this.remainingSpawnCount;
            }
            return toSpawn;
        }

        private void spawnEntities(World world, int xCoord, int yCoord, int zCoord, int range) {
            int toSpawn = this.getNumToSpawn(world.field_73012_v);
            for (int i = 0; i < toSpawn; ++i) {
                Entity e = EntityList.func_75620_a((String)this.entityId, (World)world);
                if (e == null) {
                    return;
                }
                boolean doSpawn = false;
                block1: for (int spawnTry = 0; !doSpawn && spawnTry < range + 5; ++spawnTry) {
                    int x = xCoord - range + world.field_73012_v.nextInt(range * 2 + 1);
                    int z = zCoord - range + world.field_73012_v.nextInt(range * 2 + 1);
                    for (int y = yCoord - range; y <= yCoord + range; ++y) {
                        e.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (!this.forced && e instanceof EntityLiving) {
                            doSpawn = ((EntityLiving)e).func_70601_bi();
                            if (!doSpawn) continue;
                            continue block1;
                        }
                        doSpawn = true;
                        continue block1;
                    }
                }
                if (!doSpawn) continue;
                this.spawnEntityAt(e, world);
                if (this.remainingSpawnCount <= 0) continue;
                --this.remainingSpawnCount;
            }
        }

        private void spawnEntityAt(Entity e, World world) {
            if (e instanceof EntityLiving) {
                ((EntityLiving)e).func_110161_a(null);
                ((EntityLiving)e).func_70656_aK();
            }
            if (this.customTag != null) {
                NBTTagCompound temp = new NBTTagCompound();
                e.func_70109_d(temp);
                Set keys = this.customTag.func_150296_c();
                for (String key : keys) {
                    temp.func_74782_a(key, this.customTag.func_74781_a(key));
                }
                e.func_70020_e(temp);
            }
            if (!this.customData.isEmpty()) {
                this.applyCustomData(e.func_70096_w());
            }
            world.func_72838_d(e);
        }

        private void applyCustomData(DataWatcher watcher) {
            List data = watcher.func_75685_c();
            if (data != null) {
                block0: for (WatchedData custom : this.customData) {
                    for (DataWatcher.WatchableObject vanilla : data) {
                        if (!custom.canReplace(vanilla)) continue;
                        watcher.func_75692_b(vanilla.func_75672_a(), custom.func_75669_b());
                        continue block0;
                    }
                }
            } else {
                for (WatchedData d : this.customData) {
                    d.add(watcher);
                }
            }
        }
    }

    public static final class EntitySpawnGroup {
        private int groupWeight = 1;
        List<EntitySpawnSettings> entitiesToSpawn = new ArrayList<EntitySpawnSettings>();

        public void setWeight(int weight) {
            if (weight <= 0) {
                weight = 1;
            }
            this.groupWeight = weight;
        }

        public void addSpawnSetting(EntitySpawnSettings setting) {
            this.entitiesToSpawn.add(setting);
        }

        public void spawnEntities(World world, int x, int y, int z, int grpIndex, int range) {
            EntitySpawnSettings settings;
            Iterator<EntitySpawnSettings> it = this.entitiesToSpawn.iterator();
            int index = 0;
            while (it.hasNext() && (settings = it.next()) != null) {
                settings.spawnEntities(world, x, y, z, range);
                if (settings.shouldRemove()) {
                    it.remove();
                }
                int a1 = 0;
                int b2 = settings.remainingSpawnCount;
                int a = a1 << 16 | grpIndex & 0xFFFF;
                int b = index << 16 | b2 & 0xFFFF;
                world.func_147452_c(x, y, z, AWBlocks.advancedSpawner, a, b);
                ++index;
            }
        }

        public boolean shouldRemove() {
            return this.entitiesToSpawn.isEmpty();
        }

        public List<EntitySpawnSettings> getEntitiesToSpawn() {
            return this.entitiesToSpawn;
        }

        public int getWeight() {
            return this.groupWeight;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("groupWeight", this.groupWeight);
            NBTTagList settingsList = new NBTTagList();
            for (EntitySpawnSettings setting : this.entitiesToSpawn) {
                NBTTagCompound settingTag = new NBTTagCompound();
                setting.writeToNBT(settingTag);
                settingsList.func_74742_a((NBTBase)settingTag);
            }
            tag.func_74782_a("settingsList", (NBTBase)settingsList);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.groupWeight = tag.func_74762_e("groupWeight");
            NBTTagList settingsList = tag.func_150295_c("settingsList", 10);
            for (int i = 0; i < settingsList.func_74745_c(); ++i) {
                EntitySpawnSettings setting = new EntitySpawnSettings();
                setting.readFromNBT(settingsList.func_150305_b(i));
                this.entitiesToSpawn.add(setting);
            }
        }
    }
}

