/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.core.api.AWBlocks;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public class TileDraftingStation
extends TileEntity
implements IInvBasic {
    private String structureName;
    private boolean isStarted;
    private ArrayList<ItemStack> neededResources = new ArrayList();
    private boolean isFinished;
    private int remainingTime;
    private int totalTime;
    public net.shadowmage.ancientwarfare.core.inventory.InventoryBasic inputSlots = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(27, this);
    public net.shadowmage.ancientwarfare.core.inventory.InventoryBasic outputSlot = new net.shadowmage.ancientwarfare.core.inventory.InventoryBasic(1, this);

    public void func_145845_h() {
        StructureTemplate t;
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.structureName != null && (t = StructureTemplateManager.INSTANCE.getTemplate(this.structureName)) == null) {
            this.stopCurrentWork();
        }
        if (this.structureName == null || !this.isStarted) {
            return;
        }
        if (!this.isFinished && this.tryRemoveResource()) {
            this.isFinished = true;
        }
        if (this.isFinished && this.tryFinish()) {
            this.stopCurrentWork();
        }
    }

    private boolean tryRemoveResource() {
        block0: for (int k = 0; k < this.inputSlots.func_70302_i_(); ++k) {
            ItemStack stack2 = this.inputSlots.func_70301_a(k);
            if (stack2 == null) continue;
            for (int i = 0; i < this.neededResources.size(); ++i) {
                ItemStack stack1 = this.neededResources.get(i);
                if (!InventoryTools.doItemStacksMatch(stack1, stack2)) continue;
                --stack1.field_77994_a;
                --stack2.field_77994_a;
                if (stack1.field_77994_a <= 0) {
                    this.neededResources.remove(i);
                }
                if (stack2.field_77994_a > 0) break block0;
                this.inputSlots.func_70299_a(k, null);
                break block0;
            }
        }
        return this.neededResources.isEmpty();
    }

    public void tryStart() {
        if (this.structureName != null && StructureTemplateManager.INSTANCE.getTemplate(this.structureName) != null) {
            this.isStarted = true;
        }
    }

    private boolean tryFinish() {
        if (this.outputSlot.func_70301_a(0) == null) {
            ItemStack item = new ItemStack(AWBlocks.builderBlock);
            item.func_77983_a("structureName", (NBTBase)new NBTTagString(this.structureName));
            this.outputSlot.func_70299_a(0, item);
            return true;
        }
        return false;
    }

    public String getCurrentTemplateName() {
        return this.structureName;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public List<ItemStack> getNeededResources() {
        return this.neededResources;
    }

    public void stopCurrentWork() {
        this.structureName = null;
        this.neededResources.clear();
        this.remainingTime = 0;
        this.isFinished = false;
        this.isStarted = false;
        this.func_70296_d();
    }

    public void setTemplate(String templateName) {
        if (this.isStarted) {
            return;
        }
        this.structureName = null;
        this.neededResources.clear();
        this.remainingTime = 0;
        StructureTemplate t = StructureTemplateManager.INSTANCE.getTemplate(templateName);
        if (t != null) {
            if (t.getValidationSettings().isSurvival()) {
                this.structureName = templateName;
            }
            for (ItemStack item : t.getResourceList()) {
                this.neededResources.add(item.func_77946_l());
            }
            this.calcTime();
        }
        this.func_70296_d();
    }

    private void calcTime() {
        int count = 0;
        for (ItemStack item : this.neededResources) {
            count += item.field_77994_a;
        }
        this.totalTime = this.remainingTime = count;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputSlots.readFromNBT(tag.func_74775_l("inputInventory"));
        this.outputSlot.readFromNBT(tag.func_74775_l("outputInventory"));
        this.structureName = tag.func_74764_b("structureName") ? tag.func_74779_i("structureName") : null;
        this.isStarted = tag.func_74767_n("isStarted");
        this.isFinished = tag.func_74767_n("isFinished");
        this.remainingTime = tag.func_74762_e("remainingTime");
        this.totalTime = tag.func_74762_e("totalTime");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("inputInventory", (NBTBase)this.inputSlots.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("outputInventory", (NBTBase)this.outputSlot.writeToNBT(new NBTTagCompound()));
        if (this.structureName != null) {
            tag.func_74778_a("structureName", this.structureName);
        }
        tag.func_74757_a("isStarted", this.isStarted);
        tag.func_74757_a("isFinished", this.isFinished);
        tag.func_74768_a("remainingTime", this.remainingTime);
        tag.func_74768_a("totalTime", this.totalTime);
    }

    public void func_76316_a(InventoryBasic internal) {
        this.func_70296_d();
    }
}

