/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.shadowmage.ancientwarfare.core.interfaces.ISinger;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;

public class TileSoundBlock
extends TileEntity
implements ISinger {
    private boolean playing = false;
    private boolean redstoneInteraction = false;
    private int currentDelay;
    private int tuneIndex = -1;
    private int playerCheckDelay;
    private int playerRange = 20;
    private int playTime;
    private SongPlayData tuneData = new SongPlayData();
    private Block blockCache;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.playing) {
            if (this.playTime-- <= 0) {
                this.endSong();
            }
        } else if (this.currentDelay-- <= 0) {
            if (this.tuneData.getPlayOnPlayerEntry()) {
                if (this.playerCheckDelay-- <= 0) {
                    this.playerCheckDelay = 20;
                    AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)this.playerRange, (double)this.playerRange, (double)this.playerRange);
                    List list = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
                    if (list != null && !list.isEmpty()) {
                        this.startSong();
                    }
                }
            } else if (this.isRedstoneInteraction()) {
                if (this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
                    this.startSong();
                }
            } else {
                this.startSong();
            }
        }
    }

    private void startSong() {
        if (this.tuneData.getIsRandom()) {
            this.tuneIndex = 0;
            if (this.tuneData.size() > 0) {
                this.tuneIndex = this.field_145850_b.field_73012_v.nextInt(this.tuneData.size());
            }
        } else {
            ++this.tuneIndex;
        }
        if (this.tuneIndex >= this.tuneData.size()) {
            this.tuneIndex = 0;
        }
        if (this.tuneData.size() <= 0) {
            return;
        }
        this.playing = true;
        this.playTime = this.tuneData.get(this.tuneIndex).play(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void endSong() {
        this.playing = false;
        this.playTime = 0;
        this.currentDelay = this.tuneData.getMinDelay();
        int diff = this.tuneData.getMaxDelay() - this.currentDelay;
        if (diff > 0) {
            this.currentDelay += this.field_145850_b.field_73012_v.nextInt(diff);
        }
    }

    public Packet func_145844_m() {
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, this.cacheToNBT(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (this.field_145850_b.field_72995_K && pkt.func_148853_f() == 0) {
            this.cacheFromNBT(pkt.func_148857_g());
        }
    }

    private void cacheFromNBT(NBTTagCompound tag) {
        String id = tag.func_74779_i("block");
        if (!id.isEmpty()) {
            this.blockCache = Block.func_149684_b((String)id);
        }
    }

    private NBTTagCompound cacheToNBT(NBTTagCompound tag) {
        if (this.blockCache != null) {
            tag.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.blockCache));
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tuneData.readFromNBT(tag.func_74775_l("tuneData"));
        this.redstoneInteraction = tag.func_74767_n("redstone");
        this.tuneIndex = tag.func_74762_e("tuneIndex");
        this.playerRange = tag.func_74762_e("range");
        this.cacheFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("tuneData", (NBTBase)this.tuneData.writeToNBT(new NBTTagCompound()));
        tag.func_74757_a("redstone", this.redstoneInteraction);
        tag.func_74768_a("tuneIndex", this.tuneIndex);
        tag.func_74768_a("range", this.playerRange);
        this.cacheToNBT(tag);
    }

    @Override
    public SongPlayData getSongs() {
        return this.tuneData;
    }

    public boolean isRedstoneInteraction() {
        return this.redstoneInteraction;
    }

    public void setRedstoneInteraction(boolean redstoneInteraction) {
        this.redstoneInteraction = redstoneInteraction;
    }

    public void setPlayerRange(int value) {
        this.playerRange = value;
    }

    public int getPlayerRange() {
        return this.playerRange;
    }

    public Block getBlockCache() {
        return this.blockCache;
    }

    public void setBlockCache(ItemStack itemStack) {
        this.blockCache = Block.func_149634_a((Item)itemStack.func_77973_b());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        this.func_70296_d();
    }
}

