/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public class TownGeneratorBorders {
    public static void generateBorders(World world, StructureBB exterior, StructureBB walls, StructureBB max) {
        int px;
        int pz;
        int step;
        int pz2;
        int px2;
        int fillBase;
        int levelBase = fillBase = max.min.y - 1;
        int eminx = exterior.min.x;
        int eminz = exterior.min.z;
        int emaxx = exterior.max.x;
        int emaxz = exterior.max.z;
        int minX = max.min.x;
        int maxX = walls.min.x - 1;
        for (px2 = minX; px2 <= maxX; ++px2) {
            for (pz2 = max.min.z; pz2 <= max.max.z; ++pz2) {
                step = WorldStructureGenerator.getStepNumber(px2, pz2, eminx, emaxx, eminz, emaxz);
                TownGeneratorBorders.handleBorderBlock(world, px2, pz2, fillBase - step, levelBase + step, TownGeneratorBorders.getFillBlock(world, px2, pz2, false, Blocks.field_150346_d), TownGeneratorBorders.getFillBlock(world, px2, pz2, true, (Block)Blocks.field_150349_c), true);
            }
        }
        minX = walls.max.x + 1;
        maxX = max.max.x;
        for (px2 = minX; px2 <= maxX; ++px2) {
            for (pz2 = max.min.z; pz2 <= max.max.z; ++pz2) {
                step = WorldStructureGenerator.getStepNumber(px2, pz2, eminx, emaxx, eminz, emaxz);
                TownGeneratorBorders.handleBorderBlock(world, px2, pz2, fillBase - step, levelBase + step, TownGeneratorBorders.getFillBlock(world, px2, pz2, false, Blocks.field_150346_d), TownGeneratorBorders.getFillBlock(world, px2, pz2, true, (Block)Blocks.field_150349_c), true);
            }
        }
        int minZ = max.min.z;
        int maxZ = walls.min.z - 1;
        for (pz = minZ; pz <= maxZ; ++pz) {
            for (px = max.min.x; px <= max.max.x; ++px) {
                step = WorldStructureGenerator.getStepNumber(px, pz, eminx, emaxx, eminz, emaxz);
                TownGeneratorBorders.handleBorderBlock(world, px, pz, fillBase - step, levelBase + step, TownGeneratorBorders.getFillBlock(world, px, pz, false, Blocks.field_150346_d), TownGeneratorBorders.getFillBlock(world, px, pz, true, (Block)Blocks.field_150349_c), true);
            }
        }
        minZ = walls.max.z + 1;
        maxZ = max.max.z;
        for (pz = minZ; pz <= maxZ; ++pz) {
            for (px = max.min.x; px <= max.max.x; ++px) {
                step = WorldStructureGenerator.getStepNumber(px, pz, eminx, emaxx, eminz, emaxz);
                TownGeneratorBorders.handleBorderBlock(world, px, pz, fillBase - step, levelBase + step, TownGeneratorBorders.getFillBlock(world, px, pz, false, Blocks.field_150346_d), TownGeneratorBorders.getFillBlock(world, px, pz, true, (Block)Blocks.field_150349_c), true);
            }
        }
    }

    public static void levelTownArea(World world, StructureBB walls) {
        int minX = walls.min.x;
        int minZ = walls.min.z;
        int maxX = walls.max.x;
        int maxZ = walls.max.z;
        int desiredTopBlockHeight = walls.min.y - 1;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                TownGeneratorBorders.handleBorderBlock(world, x, z, desiredTopBlockHeight, desiredTopBlockHeight, TownGeneratorBorders.getFillBlock(world, x, z, false, (Block)Blocks.field_150349_c), TownGeneratorBorders.getFillBlock(world, x, z, true, (Block)Blocks.field_150349_c), false);
                world.func_147449_b(x, desiredTopBlockHeight - 5, z, Blocks.field_150347_e);
            }
        }
    }

    private static void handleBorderBlock(World world, int x, int z, int fillLevel, int cutLevel, Block fillBlock, Block topBlock, boolean skippables) {
        int py;
        int y = TownGeneratorBorders.getTopFilledHeight(world.func_72938_d(x, z), x & 0xF, z & 0xF, skippables);
        if (y >= cutLevel) {
            for (py = world.func_72940_L(); py > cutLevel; --py) {
                world.func_147468_f(x, py, z);
            }
            world.func_147449_b(x, cutLevel, z, topBlock);
        }
        if (y <= fillLevel) {
            for (py = y + 1; py < fillLevel; ++py) {
                world.func_147449_b(x, py, z, fillBlock);
            }
            world.func_147449_b(x, fillLevel, z, topBlock);
        }
    }

    private static int getTopFilledHeight(Chunk chunk, int xInChunk, int zInChunk, boolean skippables) {
        int maxY;
        for (int y = maxY = chunk.func_76625_h() + 16; y > 0; --y) {
            Block block = chunk.func_150810_a(xInChunk, y, zInChunk);
            if (block == null || block == Blocks.field_150350_a || skippables && AWStructureStatics.skippableBlocksContains(block) || block.func_149688_o() == Material.field_151586_h) continue;
            return y;
        }
        return -1;
    }

    private static Block getFillBlock(World world, int x, int z, boolean surface, Block defaultBlock) {
        BiomeGenBase biome = world.getBiomeGenForCoordsBody(x, z);
        if (biome != null) {
            if (surface && biome.field_76752_A != null) {
                return biome.field_76752_A;
            }
            if (!surface && biome.field_76753_B != null) {
                return biome.field_76753_B;
            }
        }
        return defaultBlock;
    }
}

