/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.Random;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.town.Direction;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldGenTickHandler;

public class TownGeneratorWalls {
    public static void generateWalls(World world, TownGenerator gen, TownTemplate template, Random rng) {
        if (template.getWallStyle() <= 0) {
            return;
        }
        int minX = gen.wallsBounds.min.x;
        int minZ = gen.wallsBounds.min.z;
        int maxX = gen.wallsBounds.max.x;
        int maxZ = gen.wallsBounds.max.z;
        int minY = gen.wallsBounds.min.y;
        TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getCornerSection(rng, template), Direction.SOUTH.ordinal(), minX, minY, minZ);
        TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getCornerSection(rng, template), Direction.WEST.ordinal(), maxX, minY, minZ);
        TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getCornerSection(rng, template), Direction.NORTH.ordinal(), maxX, minY, maxZ);
        TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getCornerSection(rng, template), Direction.EAST.ordinal(), minX, minY, maxZ);
        if (template.getWallStyle() > 1) {
            int z;
            int x;
            int i;
            int chunkWidth = (maxX - minX + 1) / 16;
            int chunkLength = (maxZ - minZ + 1) / 16;
            int facingDirection = Direction.SOUTH.ordinal();
            for (i = 1; i < chunkWidth - 1; ++i) {
                x = minX + 16 * i;
                z = minZ;
                TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getWallSection(rng, template, i, chunkWidth), facingDirection, x, minY, z);
            }
            facingDirection = Direction.WEST.ordinal();
            for (i = 1; i < chunkLength - 1; ++i) {
                x = maxX;
                z = minZ + 16 * i;
                TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getWallSection(rng, template, i, chunkLength), facingDirection, x, minY, z);
            }
            facingDirection = Direction.NORTH.ordinal();
            for (i = 1; i < chunkWidth - 1; ++i) {
                x = maxX - 16 * i;
                z = maxZ;
                TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getWallSection(rng, template, i, chunkWidth), facingDirection, x, minY, z);
            }
            facingDirection = Direction.EAST.ordinal();
            for (i = 1; i < chunkLength - 1; ++i) {
                x = minX;
                z = maxZ - 16 * i;
                TownGeneratorWalls.constructTemplate(world, TownGeneratorWalls.getWallSection(rng, template, i, chunkLength), facingDirection, x, minY, z);
            }
        }
    }

    private static StructureTemplate getWallSection(Random rng, TownTemplate template, int index, int wallLength) {
        TownTemplate.TownWallEntry entry;
        int[] pattern;
        if (template.getWallStyle() == 2) {
            if (wallLength % 2 == 0) {
                int middle = wallLength / 2;
                if (index == middle) {
                    return StructureTemplateManager.INSTANCE.getTemplate(template.getRandomWeightedGateLeft(rng));
                }
                if (index == middle - 1) {
                    return StructureTemplateManager.INSTANCE.getTemplate(template.getRandomWeightedGateRight(rng));
                }
                return StructureTemplateManager.INSTANCE.getTemplate(template.getRandomWeightedWall(rng));
            }
            int middle = wallLength / 2;
            if (index == middle) {
                return StructureTemplateManager.INSTANCE.getTemplate(template.getRandomWeightedGate(rng));
            }
            return StructureTemplateManager.INSTANCE.getTemplate(template.getRandomWeightedWall(rng));
        }
        if (template.getWallStyle() == 3 && (pattern = template.getWallPattern(wallLength)) != null && wallLength <= pattern.length && (entry = template.getWall(template.getWallPattern(wallLength)[index])) != null) {
            return StructureTemplateManager.INSTANCE.getTemplate(entry.templateName);
        }
        return null;
    }

    private static StructureTemplate getCornerSection(Random rng, TownTemplate template) {
        return StructureTemplateManager.INSTANCE.getTemplate(template.getRandomWeightedCorner(rng));
    }

    private static void constructTemplate(World world, StructureTemplate template, int face, int x, int y, int z) {
        if (template == null) {
            return;
        }
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilder(world, template, face, x, y, z));
    }
}

