/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.TownPartBlock;

public class TownPartPlot {
    int x;
    int z;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    TownPartBlock block;
    StructureBB bb;
    boolean[] roadBorders;
    boolean closed;
    boolean skipped;

    public TownPartPlot(TownPartBlock block, StructureBB bb, int x, int z) {
        this.block = block;
        this.bb = bb;
        this.roadBorders = new boolean[4];
        this.x = x;
        this.z = z;
        this.reseatMinMax();
    }

    public void markClosed() {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                this.block.getPlot((int)x, (int)z).closed = true;
            }
        }
    }

    public boolean hasRoadBorder() {
        for (int i = 0; i < 4; ++i) {
            if (!this.roadBorders[i]) continue;
            return true;
        }
        return false;
    }

    private void reseatMinMax() {
        this.minX = this.x;
        this.minZ = this.z;
        this.maxX = this.x;
        this.maxZ = this.z;
    }

    public void merge(TownPartPlot other) {
        int x = this.bb.min.x;
        int z = this.bb.min.z;
        if (other.bb.min.x < this.bb.min.x) {
            x = other.bb.min.x;
        }
        if (other.bb.min.z < this.bb.min.z) {
            z = other.bb.min.z;
        }
        this.bb.min = new BlockPosition(x, this.bb.min.y, z);
        x = this.bb.max.x;
        z = this.bb.max.z;
        if (other.bb.max.x > this.bb.max.x) {
            x = other.bb.max.x;
        }
        if (other.bb.max.z > this.bb.max.z) {
            z = other.bb.max.z;
        }
        this.bb.max = new BlockPosition(x, this.bb.max.y, z);
        for (int i = 0; i < 4; ++i) {
            if (!other.roadBorders[i]) continue;
            this.roadBorders[i] = true;
        }
    }

    public int getWidth() {
        return this.bb.max.x - this.bb.min.x + 1;
    }

    public int getLength() {
        return this.bb.max.z - this.bb.min.z + 1;
    }

    public boolean expand(int xSize, int zSize) {
        StructureBB bb = this.bb.copy();
        boolean val = this.tryExpand(xSize, zSize);
        if (!val) {
            this.reseatMinMax();
            this.bb = bb;
        }
        return val;
    }

    private boolean tryExpand(int xSize, int zSize) {
        while (this.getWidth() < xSize) {
            if (this.expandEast() || this.expandWest()) continue;
            return false;
        }
        while (this.getLength() < zSize) {
            if (this.expandNorth() || this.expandSouth()) continue;
            return false;
        }
        return true;
    }

    private boolean expandNorth() {
        if (this.minZ <= 0) {
            return false;
        }
        for (int x = this.minX; x <= this.maxX; ++x) {
            if (!this.block.getPlot((int)x, (int)(this.minZ - 1)).closed) continue;
            return false;
        }
        --this.minZ;
        TownPartPlot p = this.block.getPlot(this.x, this.minZ);
        this.bb.min = new BlockPosition(this.bb.min.x, this.bb.min.y, p.bb.min.z);
        return true;
    }

    private boolean expandSouth() {
        if (this.maxZ + 1 >= this.block.plotsLength) {
            return false;
        }
        for (int x = this.minX; x <= this.maxX; ++x) {
            if (!this.block.getPlot((int)x, (int)(this.maxZ + 1)).closed) continue;
            return false;
        }
        ++this.maxZ;
        TownPartPlot p = this.block.getPlot(this.x, this.maxZ);
        this.bb.max = new BlockPosition(this.bb.max.x, this.bb.max.y, p.bb.max.z);
        return true;
    }

    private boolean expandEast() {
        if (this.minX <= 0) {
            return false;
        }
        for (int z = this.minZ; z <= this.maxZ; ++z) {
            if (!this.block.getPlot((int)(this.minX - 1), (int)z).closed) continue;
            return false;
        }
        --this.minX;
        TownPartPlot p = this.block.getPlot(this.minX, this.z);
        this.bb.min = new BlockPosition(p.bb.min.x, this.bb.min.y, this.bb.min.z);
        return true;
    }

    private boolean expandWest() {
        if (this.maxX + 1 >= this.block.plotsWidth) {
            return false;
        }
        for (int z = this.minZ; z <= this.maxZ; ++z) {
            if (!this.block.getPlot((int)(this.maxX + 1), (int)z).closed) continue;
            return false;
        }
        ++this.maxX;
        TownPartPlot p = this.block.getPlot(this.maxX, this.z);
        this.bb.max = new BlockPosition(p.bb.max.x, this.bb.max.y, this.bb.max.z);
        return true;
    }
}

