/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public final class TownTemplate {
    private String townTypeName;
    private boolean biomeWhiteList;
    private List<String> biomeList = new ArrayList<String>();
    private boolean dimensionWhiteList;
    private List<Integer> dimensionList = new ArrayList<Integer>();
    private int minSize = 3;
    private int maxSize = 9;
    private int selectionWeight;
    private int clusterValue;
    private int townBlockSize;
    private int townPlotSize;
    private int townBuildingWidthExpansion;
    private Block roadFillBlock = Blocks.field_150351_n;
    private int roadFillMeta = 0;
    private int wallStyle;
    private int wallSize;
    private int exteriorSize;
    private int exteriorPlotSize;
    private int interiorEmtpyPlotChance;
    private float randomVillagersPerChunk;
    private HashMap<Integer, TownWallEntry> wallsByID = new HashMap();
    private HashMap<Integer, int[]> wallPatterns = new HashMap();
    private int cornersTotalWeight;
    private List<TownWallEntry> cornerWalls = new ArrayList<TownWallEntry>();
    private int gatesCenterTotalWeight;
    private List<TownWallEntry> gateCenterWalls = new ArrayList<TownWallEntry>();
    private int gatesLeftTotalWeight;
    private List<TownWallEntry> gateLeftWalls = new ArrayList<TownWallEntry>();
    private int gatesRightTotalWeight;
    private List<TownWallEntry> gateRightWalls = new ArrayList<TownWallEntry>();
    private int wallTotalWeights;
    private List<TownWallEntry> walls = new ArrayList<TownWallEntry>();
    private TownStructureEntry lamp;
    private List<TownStructureEntry> uniqueStructureEntries = new ArrayList<TownStructureEntry>();
    private List<TownStructureEntry> mainStructureEntries = new ArrayList<TownStructureEntry>();
    private List<TownStructureEntry> houseStructureEntries = new ArrayList<TownStructureEntry>();
    private List<TownStructureEntry> cosmeticStructureEntries = new ArrayList<TownStructureEntry>();
    private List<TownStructureEntry> exteriorStructureEntries = new ArrayList<TownStructureEntry>();

    public void setTownTypeName(String townTypeName) {
        this.townTypeName = townTypeName;
    }

    public final String getTownTypeName() {
        return this.townTypeName;
    }

    public final boolean isBiomeWhiteList() {
        return this.biomeWhiteList;
    }

    public final void setBiomeWhiteList(boolean biomeWhiteList) {
        this.biomeWhiteList = biomeWhiteList;
    }

    public final List<String> getBiomeList() {
        return this.biomeList;
    }

    public final void setBiomeList(List<String> biomes) {
        this.biomeList = biomes;
    }

    public final boolean isDimensionWhiteList() {
        return this.dimensionWhiteList;
    }

    public final void setDimensionWhiteList(boolean dimensionWhiteList) {
        this.dimensionWhiteList = dimensionWhiteList;
    }

    public final List<Integer> getDimensionList() {
        return this.dimensionList;
    }

    public final void setDimensionList(List<Integer> dimensions) {
        this.dimensionList = dimensions;
    }

    public final List<TownStructureEntry> getUniqueStructureEntries() {
        return this.uniqueStructureEntries;
    }

    public final List<TownStructureEntry> getMainStructureEntries() {
        return this.mainStructureEntries;
    }

    public final List<TownStructureEntry> getHouseStructureEntries() {
        return this.houseStructureEntries;
    }

    public final List<TownStructureEntry> getExteriorStructureEntries() {
        return this.exteriorStructureEntries;
    }

    public final List<TownStructureEntry> getCosmeticEntries() {
        return this.cosmeticStructureEntries;
    }

    public final int getMinSize() {
        return this.minSize;
    }

    public final void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public final void setTownBuildingWidthExpansion(int townBuildingWidthExpansion) {
        this.townBuildingWidthExpansion = townBuildingWidthExpansion;
    }

    public final int getTownBuildingWidthExpansion() {
        return this.townBuildingWidthExpansion;
    }

    public final int getSelectionWeight() {
        return this.selectionWeight;
    }

    public final void setSelectionWeight(int selectionWeight) {
        this.selectionWeight = selectionWeight;
    }

    public final int getClusterValue() {
        return this.clusterValue;
    }

    public final void setClusterValue(int clusterValue) {
        this.clusterValue = clusterValue;
    }

    public final TownStructureEntry getLamp() {
        return this.lamp;
    }

    public final void setLamp(TownStructureEntry lamp) {
        this.lamp = lamp;
    }

    public final Block getRoadFillBlock() {
        return this.roadFillBlock;
    }

    public final void setRoadFillBlock(Block roadFillBlock) {
        this.roadFillBlock = roadFillBlock == null ? this.roadFillBlock : roadFillBlock;
    }

    public final void setRoadFillMeta(int roadFillMeta) {
        this.roadFillMeta = roadFillMeta;
    }

    public final int getRoadFillMeta() {
        return this.roadFillMeta;
    }

    public final int getExteriorSize() {
        return this.exteriorSize;
    }

    public final int getExteriorPlotSize() {
        return this.exteriorPlotSize;
    }

    public final void setExteriorSize(int exteriorSize) {
        this.exteriorSize = exteriorSize;
    }

    public final void setExteriorPlotSize(int exteriorPlotSize) {
        this.exteriorPlotSize = exteriorPlotSize;
    }

    public int getInteriorEmtpyPlotChance() {
        return this.interiorEmtpyPlotChance;
    }

    public void setInteriorEmtpyPlotChance(int interiorEmtpyPlotChance) {
        this.interiorEmtpyPlotChance = interiorEmtpyPlotChance;
    }

    public final int[] getWallPattern(int size) {
        return this.wallPatterns.get(size);
    }

    public final int getWallStyle() {
        return this.wallStyle;
    }

    public final int getWallSize() {
        return this.wallSize;
    }

    public final void setWallStyle(int wallStyle) {
        this.wallStyle = wallStyle;
    }

    public final void setWallSize(int wallSize) {
        this.wallSize = wallSize;
    }

    public final void addWallPattern(int size, int[] pattern) {
        this.wallPatterns.put(size, pattern);
    }

    public final void addWall(TownWallEntry e) {
        this.wallsByID.put(e.id, e);
        if (e.typeName.equalsIgnoreCase("wall")) {
            this.walls.add(e);
            this.wallTotalWeights += e.weight;
        } else if (e.typeName.equalsIgnoreCase("corner")) {
            this.cornerWalls.add(e);
            this.cornersTotalWeight += e.weight;
        } else if (e.typeName.equalsIgnoreCase("gate")) {
            this.gateCenterWalls.add(e);
            this.gatesCenterTotalWeight += e.weight;
        } else if (e.typeName.equalsIgnoreCase("lgate")) {
            this.gateLeftWalls.add(e);
            this.gatesLeftTotalWeight += e.weight;
        } else if (e.typeName.equalsIgnoreCase("rgate")) {
            this.gateRightWalls.add(e);
            this.gatesRightTotalWeight += e.weight;
        }
    }

    public final int getTownBlockSize() {
        return this.townBlockSize;
    }

    public final int getTownPlotSize() {
        return this.townPlotSize;
    }

    public final void setTownBlockSize(int townBlockSize) {
        this.townBlockSize = townBlockSize;
    }

    public final void setTownPlotSize(int townPlotSize) {
        this.townPlotSize = townPlotSize;
    }

    public float getRandomVillagersPerChunk() {
        return this.randomVillagersPerChunk;
    }

    public void setRandomVillagersPerChunk(float randomVillagersPerChunk) {
        this.randomVillagersPerChunk = randomVillagersPerChunk;
    }

    public final TownWallEntry getWall(int id) {
        return this.wallsByID.get(id);
    }

    public final String getRandomWeightedWall(Random rng) {
        return TownTemplate.getRandomWeightedWallPiece(rng, this.walls, this.wallTotalWeights);
    }

    public final String getRandomWeightedCorner(Random rng) {
        return TownTemplate.getRandomWeightedWallPiece(rng, this.cornerWalls, this.cornersTotalWeight);
    }

    public final String getRandomWeightedGate(Random rng) {
        return TownTemplate.getRandomWeightedWallPiece(rng, this.gateCenterWalls, this.gatesCenterTotalWeight);
    }

    public final String getRandomWeightedGateLeft(Random rng) {
        return TownTemplate.getRandomWeightedWallPiece(rng, this.gateLeftWalls, this.gatesLeftTotalWeight);
    }

    public final String getRandomWeightedGateRight(Random rng) {
        return TownTemplate.getRandomWeightedWallPiece(rng, this.gateRightWalls, this.gatesRightTotalWeight);
    }

    private static String getRandomWeightedWallPiece(Random rng, List<TownWallEntry> list, int totalWeight) {
        int roll = rng.nextInt(totalWeight);
        for (TownWallEntry e : list) {
            if ((roll -= e.weight) >= 0) continue;
            return e.templateName;
        }
        return null;
    }

    public final void validateStructureEntries() {
        this.validateStructureList(this.uniqueStructureEntries);
        this.validateStructureList(this.mainStructureEntries);
        this.validateStructureList(this.houseStructureEntries);
        this.validateStructureList(this.cosmeticStructureEntries);
        this.validateStructureList(this.exteriorStructureEntries);
        TownStructureEntry e = this.getLamp();
        if (e != null && StructureTemplateManager.INSTANCE.getTemplate(e.templateName) == null) {
            AWLog.logError("Error loading lamp template: " + e.templateName);
        }
        this.wallTotalWeights = this.validateWallList(this.walls, this.wallTotalWeights);
        this.cornersTotalWeight = this.validateWallList(this.cornerWalls, this.cornersTotalWeight);
        this.gatesCenterTotalWeight = this.validateWallList(this.gateCenterWalls, this.gatesCenterTotalWeight);
        this.gatesLeftTotalWeight = this.validateWallList(this.gateLeftWalls, this.gatesLeftTotalWeight);
        this.gatesRightTotalWeight = this.validateWallList(this.gateRightWalls, this.gatesRightTotalWeight);
    }

    private void validateStructureList(Collection<TownStructureEntry> entries) {
        TownStructureEntry e;
        Iterator<TownStructureEntry> it = entries.iterator();
        while (it.hasNext() && (e = it.next()) != null) {
            if (StructureTemplateManager.INSTANCE.getTemplate(e.templateName) != null) continue;
            AWLog.logError("Error loading structure template: " + e.templateName + " for town: " + this.townTypeName);
            it.remove();
        }
    }

    private int validateWallList(Collection<TownWallEntry> entries, int originalWeight) {
        TownWallEntry e;
        Iterator<TownWallEntry> it = entries.iterator();
        while (it.hasNext() && (e = it.next()) != null) {
            if (StructureTemplateManager.INSTANCE.getTemplate(e.templateName) != null) continue;
            AWLog.logError("Error loading structure template: " + e.templateName + " for town: " + this.townTypeName);
            it.remove();
            originalWeight -= e.weight;
        }
        return originalWeight;
    }

    public final boolean isValid() {
        if (this.wallStyle > 0 && this.cornerWalls.isEmpty()) {
            AWLog.logError("Town template of: " + this.townTypeName + " is missing corner wall type for specified wall style of: " + this.wallStyle);
            return false;
        }
        if (this.wallStyle > 1 && (this.walls.isEmpty() || this.gateCenterWalls.isEmpty() || this.gateLeftWalls.isEmpty() || this.gateRightWalls.isEmpty())) {
            AWLog.logError("Town template of: " + this.townTypeName + " is missing one or more wall types for specified wall style of: " + this.wallStyle);
            return false;
        }
        return this.townTypeName != null && !this.townTypeName.isEmpty();
    }

    public static final class TownWallEntry {
        String templateName;
        String typeName;
        int weight;
        int id;

        public TownWallEntry(String name, String type, int id, int weight) {
            this.templateName = name;
            this.typeName = type;
            this.id = id;
            this.weight = weight;
        }

        public String toString() {
            return "[Town Wall: " + this.typeName + " :: " + this.id + " :: " + this.templateName + "]";
        }
    }

    public static final class TownStructureEntry {
        String templateName;
        int min;

        public TownStructureEntry(String name, int min) {
            this.templateName = name;
            this.min = min;
        }

        public String toString() {
            return "[Town Structure: " + this.templateName + " :: " + this.min + "]";
        }
    }
}

