/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.world_gen;

import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;

public class StructureEntry {
    public String name;
    private int value;
    public final StructureBB bb;

    public StructureEntry(int x, int y, int z, int face, StructureTemplate template) {
        this.name = template.name;
        this.bb = new StructureBB(x, y, z, face, template.xSize, template.ySize, template.zSize, template.xOffset, template.yOffset, template.zOffset);
        this.value = template.getValidationSettings().getClusterValue();
    }

    public StructureEntry(StructureBB bb, String name, int value) {
        this.name = name;
        this.bb = bb;
        this.value = value;
    }

    public StructureEntry() {
        this.bb = new StructureBB(new BlockPosition(), new BlockPosition());
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("value", this.value);
        tag.func_74783_a("bb", new int[]{this.bb.min.x, this.bb.min.y, this.bb.min.z, this.bb.max.x, this.bb.max.y, this.bb.max.z});
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.value = tag.func_74762_e("value");
        int[] datas = tag.func_74759_k("bb");
        if (datas.length >= 6) {
            this.bb.min = new BlockPosition(datas[0], datas[1], datas[2]);
            this.bb.max = new BlockPosition(datas[3], datas[4], datas[5]);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public StructureBB getBB() {
        return this.bb;
    }
}

