/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.world_gen;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.town.WorldTownGenerator;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public final class WorldGenTickHandler {
    public static final WorldGenTickHandler INSTANCE = new WorldGenTickHandler();
    private final List<ChunkGenerationTicket> newWorldGenTickets = new ArrayList<ChunkGenerationTicket>();
    private final List<ChunkGenerationTicket> newTownGenTickets = new ArrayList<ChunkGenerationTicket>();
    private final List<ChunkGenerationTicket> chunksToGen;
    private final List<ChunkGenerationTicket> townChunksToGen;
    private final List<StructureTicket> newStructureGenTickets = new ArrayList<StructureTicket>();
    private final List<StructureTicket> structuresToGen;

    private WorldGenTickHandler() {
        this.chunksToGen = new ArrayList<ChunkGenerationTicket>();
        this.townChunksToGen = new ArrayList<ChunkGenerationTicket>();
        this.structuresToGen = new ArrayList<StructureTicket>();
    }

    public void addChunkForGeneration(World world, int chunkX, int chunkZ) {
        this.newWorldGenTickets.add(new ChunkGenerationTicket(world, chunkX, chunkZ));
    }

    public void addChunkForTownGeneration(World world, int chunkX, int chunkZ) {
        this.newTownGenTickets.add(new ChunkGenerationTicket(world, chunkX, chunkZ));
    }

    public void addStructureForGeneration(StructureBuilder builder) {
        this.newStructureGenTickets.add(new StructureGenerationTicket(builder));
    }

    public void addStructureGenCallback(StructureGenerationCallbackTicket tk) {
        this.newStructureGenTickets.add(tk);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            this.genChunks();
            this.genStructures();
            this.genTowns();
        }
    }

    public void finalTick() {
        while (!this.chunksToGen.isEmpty()) {
            this.genChunks();
        }
        while (!this.structuresToGen.isEmpty()) {
            this.genStructures();
        }
        while (!this.townChunksToGen.isEmpty()) {
            this.genTowns();
        }
    }

    private void genChunks() {
        if (!this.chunksToGen.isEmpty()) {
            ChunkGenerationTicket tk = this.chunksToGen.remove(0);
            WorldStructureGenerator.INSTANCE.generateAt(tk.chunkX, tk.chunkZ, tk.getWorld());
        }
        if (!this.newWorldGenTickets.isEmpty()) {
            this.chunksToGen.addAll(this.newWorldGenTickets);
            this.newWorldGenTickets.clear();
        }
    }

    private void genTowns() {
        if (!this.townChunksToGen.isEmpty()) {
            ChunkGenerationTicket tk = this.townChunksToGen.remove(0);
            WorldTownGenerator.INSTANCE.attemptGeneration(tk.getWorld(), tk.chunkX * 16, tk.chunkZ * 16);
        }
        if (!this.newTownGenTickets.isEmpty()) {
            this.townChunksToGen.addAll(this.newTownGenTickets);
            this.newTownGenTickets.clear();
        }
    }

    private void genStructures() {
        if (!this.structuresToGen.isEmpty()) {
            this.structuresToGen.remove(0).call();
        }
        if (!this.newStructureGenTickets.isEmpty()) {
            this.structuresToGen.addAll(this.newStructureGenTickets);
            this.newStructureGenTickets.clear();
        }
    }

    public static interface StructureGenerationCallbackTicket
    extends StructureTicket {
    }

    private static final class StructureGenerationTicket
    implements StructureTicket {
        private final StructureBuilder builder;

        public StructureGenerationTicket(StructureBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void call() {
            this.builder.instantConstruction();
        }
    }

    private static interface StructureTicket {
        public void call();
    }

    private static class ChunkGenerationTicket {
        final int world;
        final int chunkX;
        final int chunkZ;

        public ChunkGenerationTicket(World world, int x, int z) {
            this.world = world.field_73011_w.field_76574_g;
            this.chunkX = x;
            this.chunkZ = z;
        }

        public World getWorld() {
            return DimensionManager.getWorld((int)this.world);
        }
    }
}

