/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.parser.ConfigFile;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ThrowingBiConsumer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ConfigTagImpl
implements ConfigTag {
    private final ConfigFile configFile;
    public String name;
    public String version;
    public Map<String, ConfigTagImpl> children;
    public ConfigTagImpl parent;
    public boolean dirty;
    public List<String> comment;
    public ConfigTag.TagType type;
    public ConfigTag.TagType listType;
    public Object value;
    public Object defaultValue;
    public boolean syncToClient;
    public ThrowingBiConsumer<ConfigTag, ConfigTag.SyncType, ConfigTag.SyncException> syncCallback;

    public ConfigTagImpl(String name, ConfigTagImpl parent) {
        this(null, name, parent);
    }

    public ConfigTagImpl(ConfigFile configFile, String name, ConfigTagImpl parent) {
        this.configFile = configFile;
        this.name = name;
        this.parent = parent;
        this.children = new LinkedHashMap<String, ConfigTagImpl>();
        this.comment = new LinkedList<String>();
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    @Nullable
    public ConfigTag getParent() {
        return this.parent;
    }

    @Override
    public boolean isCategory() {
        return this.value == null || !this.children.isEmpty();
    }

    @Override
    public boolean isValue() {
        return this.children.isEmpty() && this.value != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        ArrayList<String> list = new ArrayList<String>();
        ConfigTag parent = this;
        while ((parent = parent.getParent()) != null) {
            list.add(parent.getName());
        }
        StringBuilder s = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            s.append((String)list.get(i)).append(".");
        }
        s.append(this.getName());
        return s.toString();
    }

    @Override
    public boolean isDirty() {
        return this.dirty || this.hasParent() && this.parent.isDirty();
    }

    @Override
    public ConfigTagImpl markDirty() {
        this.dirty = true;
        if (this.hasParent()) {
            this.parent.markDirty();
        }
        return this;
    }

    @Override
    public void clear() {
        if (this.isCategory()) {
            this.children.clear();
            this.markDirty();
        }
    }

    protected void onSave() {
        this.dirty = false;
        this.children.values().forEach(ConfigTagImpl::onSave);
    }

    @Override
    public void save() {
        if (this.hasParent()) {
            this.getParent().save();
            return;
        }
        if (this.isDirty()) {
            this.configFile.save(this);
            this.onSave();
        }
    }

    @Override
    public ConfigTag load() {
        if (this.hasParent()) {
            throw new IllegalStateException("Must call load on parent.");
        }
        this.configFile.load();
        return this;
    }

    @Override
    public boolean hasTag(String name) {
        return this.value == null && this.children.containsKey(name);
    }

    @Override
    public ConfigTagImpl getTag(String name) {
        this.addTagCheck();
        return this.children.computeIfAbsent(name, s -> new ConfigTagImpl((String)s, this));
    }

    @Override
    @Nullable
    public ConfigTagImpl getTagIfPresent(String name) {
        this.addTagCheck();
        return this.children.get(name);
    }

    @Override
    public ConfigTagImpl deleteTag(String name) {
        if (this.isCategory()) {
            this.children.remove(name);
        }
        return this;
    }

    @Override
    public List<String> getChildNames() {
        return new LinkedList<String>(this.children.keySet());
    }

    @Override
    public void walkTags(Consumer<ConfigTag> consumer) {
        if (!this.isCategory()) {
            throw new UnsupportedOperationException("Unable to walk a value.");
        }
        for (ConfigTagImpl tag : this.children.values()) {
            consumer.accept(tag);
            if (!tag.isCategory()) continue;
            tag.walkTags(consumer);
        }
    }

    @Override
    public ConfigTagImpl resetToDefault() {
        if (this.isCategory()) {
            this.children.values().forEach(ConfigTagImpl::resetToDefault);
        } else {
            this.value = this.defaultValue;
        }
        return this;
    }

    @Override
    public String getTagVersion() {
        return this.version;
    }

    @Override
    public ConfigTagImpl setTagVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public ConfigTag.TagType getTagType() {
        return this.type;
    }

    @Override
    public ConfigTag.TagType getListType() {
        return this.listType;
    }

    @Override
    public Object getRawValue() {
        return this.value;
    }

    @Override
    public ConfigTagImpl setComment(List<String> lines) {
        this.comment = new LinkedList<String>(lines);
        this.markDirty();
        return this;
    }

    @Override
    public boolean getBoolean() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.BOOLEAN) {
            throw new UnsupportedOperationException("ConfigTag is not of a Boolean type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof Boolean)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (Boolean)this.value;
    }

    @Override
    public String getString() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.STRING) {
            throw new UnsupportedOperationException("ConfigTag is not of a String type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof String)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (String)this.value;
    }

    @Override
    public int getInt() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.INT) {
            throw new UnsupportedOperationException("ConfigTag is not of a Integer type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof Integer)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (Integer)this.value;
    }

    @Override
    public int getHex() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.HEX) {
            throw new UnsupportedOperationException("ConfigTag is not of a Hex type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof Integer)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (Integer)this.value;
    }

    @Override
    public double getDouble() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.DOUBLE) {
            throw new UnsupportedOperationException("ConfigTag is not of a Double type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof Double)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (Double)this.value;
    }

    @Override
    public ConfigTagImpl setDefaultBoolean(boolean value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setBoolean(value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultString(String value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setString(value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultInt(int value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setInt(value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultHex(int value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setHex(value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultDouble(double value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setDouble(value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setBoolean(boolean value) {
        this.setValueCheck();
        this.type = ConfigTag.TagType.BOOLEAN;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTagImpl setString(String value) {
        this.setValueCheck();
        this.type = ConfigTag.TagType.STRING;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTagImpl setInt(int value) {
        this.setValueCheck();
        this.type = ConfigTag.TagType.INT;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTagImpl setHex(int value) {
        this.setValueCheck();
        this.value = value;
        this.type = ConfigTag.TagType.HEX;
        this.markDirty();
        return this;
    }

    @Override
    public ConfigTagImpl setDouble(double value) {
        this.setValueCheck();
        this.type = ConfigTag.TagType.DOUBLE;
        this.value = value;
        this.markDirty();
        return this;
    }

    @Override
    public List<Boolean> getBooleanList() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.LIST) {
            throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
        }
        if (this.listType != ConfigTag.TagType.BOOLEAN) {
            throw new UnsupportedOperationException("List is not of a Boolean type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof List)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (List)this.value;
    }

    @Override
    public List<String> getStringList() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.LIST) {
            throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
        }
        if (this.listType != ConfigTag.TagType.STRING) {
            throw new UnsupportedOperationException("List is not of a String type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof List)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (List)this.value;
    }

    @Override
    public List<Integer> getIntList() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.LIST) {
            throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
        }
        if (this.listType != ConfigTag.TagType.INT) {
            throw new UnsupportedOperationException("List is not of a Integer type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof List)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (List)this.value;
    }

    @Override
    public List<Integer> getHexList() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.LIST) {
            throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
        }
        if (this.listType != ConfigTag.TagType.HEX) {
            throw new UnsupportedOperationException("List is not of a Hex type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof List)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (List)this.value;
    }

    @Override
    public List<Double> getDoubleList() {
        if (this.value == null) {
            throw new IllegalStateException("Tag in a weird state, value is null, did you set a default?");
        }
        if (this.type != ConfigTag.TagType.LIST) {
            throw new UnsupportedOperationException("ConfigTag is not of a List type, Actual: " + (Object)((Object)this.type));
        }
        if (this.listType != ConfigTag.TagType.DOUBLE) {
            throw new UnsupportedOperationException("List is not of a Double type, Actual: " + (Object)((Object)this.type));
        }
        if (!(this.value instanceof List)) {
            throw new IllegalStateException(String.format("Tag appears to be in an invalid state.. Requested: %s, Current %s.", new Object[]{this.type, this.value.getClass()}));
        }
        return (List)this.value;
    }

    @Override
    public ConfigTagImpl setDefaultBooleanList(List<Boolean> value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setBooleanList((List)value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultStringList(List<String> value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setStringList((List)value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultIntList(List<Integer> value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setIntList((List)value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultHexList(List<Integer> value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setHexList((List)value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setDefaultDoubleList(List<Double> value) {
        this.setDefaultCheck();
        this.defaultValue = value;
        if (this.value == null) {
            this.setDoubleList((List)value);
        }
        return this;
    }

    protected void setList(List<?> value) {
        this.setValueCheck();
        this.type = ConfigTag.TagType.LIST;
        this.value = value;
        this.markDirty();
    }

    @Override
    public ConfigTagImpl setBooleanList(List<Boolean> value) {
        this.setList(value);
        this.listType = ConfigTag.TagType.BOOLEAN;
        return this;
    }

    @Override
    public ConfigTagImpl setStringList(List<String> value) {
        this.setList(value);
        this.listType = ConfigTag.TagType.STRING;
        return this;
    }

    @Override
    public ConfigTagImpl setIntList(List<Integer> value) {
        this.setList(value);
        this.listType = ConfigTag.TagType.INT;
        return this;
    }

    @Override
    public ConfigTagImpl setHexList(List<Integer> value) {
        this.setList(value);
        this.listType = ConfigTag.TagType.HEX;
        return this;
    }

    @Override
    public ConfigTagImpl setDoubleList(List<Double> value) {
        this.setList(value);
        this.listType = ConfigTag.TagType.DOUBLE;
        return this;
    }

    @Override
    public ConfigTag copy() {
        return this.copy(null);
    }

    @Override
    public ConfigTag copy(ConfigTag parent) {
        ConfigTagImpl copy = new ConfigTagImpl(this.name, (ConfigTagImpl)parent);
        copy.version = this.version;
        copy.comment = new LinkedList<String>(this.comment);
        if (this.isCategory()) {
            for (Map.Entry<String, ConfigTagImpl> entry : this.children.entrySet()) {
                copy.children.put(entry.getKey(), (ConfigTagImpl)entry.getValue().copy(copy));
            }
        } else {
            copy.type = this.type;
            copy.listType = this.listType;
            copy.value = this.type.copy(this.value);
            if (this.defaultValue != null) {
                copy.defaultValue = this.type.copy(this.defaultValue);
            }
        }
        copy.syncToClient = this.syncToClient;
        copy.syncCallback = this.syncCallback;
        return copy;
    }

    @Override
    public ConfigTag copyFrom(ConfigTag other) {
        if (this.isCategory()) {
            for (Map.Entry<String, ConfigTagImpl> entry : this.children.entrySet()) {
                ConfigTag otherTag = other.getTagIfPresent(entry.getKey());
                if (otherTag == null) {
                    throw new IllegalArgumentException("copyFrom called with a tag that does not have the same children. Missing: " + entry.getKey());
                }
                entry.getValue().copyFrom(otherTag);
            }
        } else {
            this.value = this.type.copy(((ConfigTagImpl)other).value);
        }
        return this;
    }

    @Override
    public ConfigTagImpl setSyncToClient() {
        this.children.values().forEach(ConfigTag::setSyncToClient);
        this.syncToClient = true;
        return this;
    }

    @Override
    public ConfigTagImpl setSyncCallback(ThrowingBiConsumer<ConfigTag, ConfigTag.SyncType, ConfigTag.SyncException> consumer) {
        this.syncCallback = consumer;
        return this;
    }

    @Override
    public boolean requiresSync() {
        for (ConfigTagImpl tag : this.children.values()) {
            if (!tag.requiresSync()) continue;
            return true;
        }
        return this.syncToClient;
    }

    @Override
    public void runSync(ConfigTag.SyncType type) throws ConfigTag.SyncException {
        if (this.syncCallback != null) {
            this.syncCallback.accept(this, type);
        }
        for (ConfigTagImpl tag : this.children.values()) {
            tag.runSync(type);
        }
    }

    @Override
    public void read(MCDataInput in) {
        if (this.isCategory()) {
            int numChildren = in.readVarInt();
            for (int i = 0; i < numChildren; ++i) {
                String name = in.readString();
                ConfigTagImpl found = this.children.get(name);
                if (found == null) {
                    throw new IllegalArgumentException("read called with data that does not align to this tag, Missing: " + name);
                }
                found.read(in);
            }
        } else {
            this.value = this.type.read(in, this.listType);
        }
    }

    @Override
    public void write(MCDataOutput out) {
        if (this.isCategory()) {
            out.writeVarInt(this.children.size());
            for (Map.Entry<String, ConfigTagImpl> entry : this.children.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().write(out);
            }
        } else {
            this.type.write(out, this.listType, this.value);
        }
    }

    protected void addTagCheck() {
        if (this.value != null) {
            throw new UnsupportedOperationException("Unable to get a child tag for a tag that has a value.");
        }
    }

    protected void setValueCheck() {
        if (!this.children.isEmpty()) {
            throw new UnsupportedOperationException("Unable to set the value for a tag that has children.");
        }
    }

    protected void setDefaultCheck() {
        if (this.defaultValue != null) {
            throw new IllegalStateException("Unable to set the default value of a tag that already has a default value.");
        }
    }
}

