/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class CachedFormat {
    public static final Map<VertexFormat, CachedFormat> formatCache = new ConcurrentHashMap<VertexFormat, CachedFormat>();
    private static final CachedFormat BLOCK = new CachedFormat(DefaultVertexFormats.field_176600_a);
    public VertexFormat format;
    public boolean hasPosition;
    public boolean hasNormal;
    public boolean hasColor;
    public boolean hasUV;
    public boolean hasOverlay;
    public boolean hasLightMap;
    public int positionIndex = -1;
    public int normalIndex = -1;
    public int colorIndex = -1;
    public int uvIndex = -1;
    public int lightMapIndex = -1;
    public int elementCount;

    public static CachedFormat lookup(VertexFormat format) {
        if (format == DefaultVertexFormats.field_176600_a) {
            return BLOCK;
        }
        return formatCache.computeIfAbsent(format, CachedFormat::new);
    }

    public CachedFormat(VertexFormat format) {
        this.format = format;
        List elements = format.func_177343_g();
        this.elementCount = elements.size();
        block10: for (int i = 0; i < this.elementCount; ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            block0 : switch (element.func_177375_c()) {
                case POSITION: {
                    if (this.hasPosition) {
                        throw new IllegalStateException("Found 2 position elements..");
                    }
                    this.hasPosition = true;
                    this.positionIndex = i;
                    continue block10;
                }
                case NORMAL: {
                    if (this.hasNormal) {
                        throw new IllegalStateException("Found 2 normal elements..");
                    }
                    this.hasNormal = true;
                    this.normalIndex = i;
                    continue block10;
                }
                case COLOR: {
                    if (this.hasColor) {
                        throw new IllegalStateException("Found 2 color elements..");
                    }
                    this.hasColor = true;
                    this.colorIndex = i;
                    continue block10;
                }
                case UV: {
                    switch (element.func_177369_e()) {
                        case 0: {
                            if (this.hasUV) {
                                throw new IllegalStateException("Found 2 UV elements..");
                            }
                            this.hasUV = true;
                            this.uvIndex = i;
                            break block0;
                        }
                        case 1: {
                            if (this.hasLightMap) {
                                throw new IllegalStateException("Found 2 LightMap elements..");
                            }
                            this.hasLightMap = true;
                            this.lightMapIndex = i;
                            break block0;
                        }
                    }
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CachedFormat)) {
            return false;
        }
        CachedFormat other = (CachedFormat)obj;
        return other.elementCount == this.elementCount && other.positionIndex == this.positionIndex && other.normalIndex == this.normalIndex && other.colorIndex == this.colorIndex && other.uvIndex == this.uvIndex && other.lightMapIndex == this.lightMapIndex;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.elementCount;
        result = 31 * result + this.positionIndex;
        result = 31 * result + this.normalIndex;
        result = 31 * result + this.colorIndex;
        result = 31 * result + this.uvIndex;
        result = 31 * result + this.lightMapIndex;
        return result;
    }
}

