/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.model.bakedmodels.AbstractPerspectiveLayeredModel;
import codechicken.lib.model.bakedmodels.ModelProperties;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;

public class PerspectiveAwareLayeredModel
extends AbstractPerspectiveLayeredModel {
    private final ImmutableMap<BlockRenderLayer, Map<Direction, List<BakedQuad>>> layerFaceQuadMap;
    private final ImmutableMap<BlockRenderLayer, List<BakedQuad>> layerGeneralQuads;

    public PerspectiveAwareLayeredModel(Map<BlockRenderLayer, Map<Direction, List<BakedQuad>>> layerFaceQuadMap, ModelProperties.PerspectiveProperties properties) {
        this(layerFaceQuadMap, (Map<BlockRenderLayer, List<BakedQuad>>)ImmutableMap.of(), properties, BlockRenderLayer.SOLID);
    }

    public PerspectiveAwareLayeredModel(Map<BlockRenderLayer, Map<Direction, List<BakedQuad>>> layerFaceQuadMap, Map<BlockRenderLayer, List<BakedQuad>> layerGeneralQuads, ModelProperties.PerspectiveProperties properties, BlockRenderLayer generallayer) {
        super(properties, generallayer);
        this.layerFaceQuadMap = ImmutableMap.copyOf(layerFaceQuadMap);
        this.layerGeneralQuads = ImmutableMap.copyOf(layerGeneralQuads);
    }

    @Override
    public List<BakedQuad> getLayerQuads(BlockState state, Direction side, BlockRenderLayer layer, Random rand, IModelData data) {
        Map faceQuadMap;
        if (side == null) {
            if (this.layerGeneralQuads.containsKey((Object)layer)) {
                return (List)this.layerGeneralQuads.get((Object)layer);
            }
        } else if (this.layerFaceQuadMap.containsKey((Object)layer) && (faceQuadMap = (Map)this.layerFaceQuadMap.get((Object)layer)).containsKey(side)) {
            return (List)faceQuadMap.get(side);
        }
        return Collections.emptyList();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

