/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.model.bakedmodels.PerspectiveAwareLayeredModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.generation.IBlockBakery;
import codechicken.lib.model.bakery.generation.IItemBakery;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.model.bakery.generation.ISimpleBlockBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import codechicken.lib.model.bakery.key.IItemStackKeyGenerator;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.util.LogUtils;
import codechicken.lib.util.ResourceUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    private static final Logger logger = LogManager.getLogger();
    private static boolean DEBUG = Boolean.parseBoolean(System.getProperty("ccl.debugBakeryLogging"));
    private static boolean FORCE_BLOCK_REBAKE = Boolean.parseBoolean(System.getProperty("ccl.debugForceBlockModelRebake"));
    private static boolean FORCE_ITEM_REBAKE = Boolean.parseBoolean(System.getProperty("ccl.debugForceItemModelRebake"));
    private static Cache<String, IBakedModel> keyModelCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static Map<Item, IItemStackKeyGenerator> itemKeyGeneratorMap = Collections.synchronizedMap(new HashMap());
    private static Map<Block, IBlockStateKeyGenerator> blockKeyGeneratorMap = Collections.synchronizedMap(new HashMap());
    private static IBakedModel missingModel;
    public static final IBlockStateKeyGenerator defaultBlockKeyGenerator;
    public static final IItemStackKeyGenerator defaultItemKeyGenerator;

    public static void init() {
        ResourceUtils.registerReloadListener((resourceManager, p) -> {
            if (p.test(VanillaResourceType.MODELS)) {
                ModelBakery.nukeModelCache();
            }
        });
    }

    public static IBlockStateKeyGenerator getKeyGenerator(Block block) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            return blockKeyGeneratorMap.get(block);
        }
        return defaultBlockKeyGenerator;
    }

    public static IItemStackKeyGenerator getKeyGenerator(Item item) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            return itemKeyGeneratorMap.get(item);
        }
        return defaultItemKeyGenerator;
    }

    public static void registerBlockKeyGenerator(Block block, IBlockStateKeyGenerator generator) {
        if (blockKeyGeneratorMap.containsKey(block)) {
            throw new IllegalArgumentException("Unable to register IBlockStateKeyGenerator as one is already registered for block:" + block.getRegistryName());
        }
        blockKeyGeneratorMap.put(block, generator);
    }

    public static void registerItemKeyGenerator(Item item, IItemStackKeyGenerator generator) {
        if (itemKeyGeneratorMap.containsKey(item)) {
            throw new IllegalArgumentException("Unable to register IItemStackKeyGenerator as one is already registered for item: " + item.getRegistryName());
        }
        itemKeyGeneratorMap.put(item, generator);
    }

    public static IBakedModel getCachedItemModel(ItemStack stack) {
        IItemStackKeyGenerator generator = ModelBakery.getKeyGenerator(stack.func_77973_b());
        String key = generator.generateKey(stack);
        IBakedModel model = (IBakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null || FORCE_ITEM_REBAKE) {
            try {
                model = ModelBakery.timeModelGeneration(ModelBakery::generateItemModel, stack, "ITEM: " + key);
            }
            catch (Throwable t) {
                LogUtils.errorOnce(logger, t, "ItemBaking", "Fatal exception thrown whilst baking item model for: " + stack, new Object[0]);
                BakingVertexBuffer buffer = BakingVertexBuffer.create();
                if (buffer.field_179010_r) {
                    buffer.func_178977_d();
                    buffer.func_178965_a();
                }
                return missingModel;
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static IBakedModel generateItemModel(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IBakeryProvider) {
            IItemBakery bakery = (IItemBakery)((IBakeryProvider)item).getBakery();
            LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
            HashMap<Direction, List<BakedQuad>> faceQuads = new HashMap<Direction, List<BakedQuad>>();
            generalQuads.addAll(bakery.bakeItemQuads(null, stack));
            for (Direction face : Direction.field_82609_l) {
                LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                quads.addAll(bakery.bakeItemQuads(face, stack));
                faceQuads.put(face, quads);
            }
            ModelProperties.PerspectiveProperties properties = bakery.getModelProperties(stack);
            return new PerspectiveAwareBakedModel(faceQuads, generalQuads, properties);
        }
        return missingModel;
    }

    public static IBakedModel getCachedModel(BlockState state, IModelData data) {
        if (state == null) {
            return missingModel;
        }
        IBlockStateKeyGenerator keyGenerator = ModelBakery.getKeyGenerator(state.func_177230_c());
        String key = keyGenerator.generateKey(state, data);
        IBakedModel model = (IBakedModel)keyModelCache.getIfPresent((Object)key);
        if (model == null || FORCE_BLOCK_REBAKE) {
            try {
                model = ModelBakery.timeModelGeneration(ModelBakery::generateModel, state, data, "BLOCK: " + key);
            }
            catch (Throwable t) {
                LogUtils.errorOnce(logger, t, "BlockBaking", "Fatal exception thrown whilst baking block model for: " + state, new Object[0]);
                BakingVertexBuffer buffer = BakingVertexBuffer.create();
                if (buffer.field_179010_r) {
                    buffer.func_178977_d();
                    buffer.func_178965_a();
                }
                return missingModel;
            }
            if (model != missingModel) {
                keyModelCache.put((Object)key, (Object)model);
            }
        }
        return model;
    }

    public static IBakedModel generateModel(BlockState state, IModelData data) {
        if (state.func_177230_c() instanceof IBakeryProvider) {
            IBlockBakery bakery = (IBlockBakery)((IBakeryProvider)state.func_177230_c()).getBakery();
            if (bakery instanceof ISimpleBlockBakery) {
                ISimpleBlockBakery simpleBakery = (ISimpleBlockBakery)bakery;
                LinkedList<BakedQuad> generalQuads = new LinkedList<BakedQuad>();
                HashMap<Direction, List<BakedQuad>> faceQuads = new HashMap<Direction, List<BakedQuad>>();
                generalQuads.addAll(simpleBakery.bakeQuads(null, state, data));
                for (Direction face : Direction.field_82609_l) {
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(simpleBakery.bakeQuads(face, state, data));
                    faceQuads.put(face, quads);
                }
                ModelProperties modelProperties = new ModelProperties(true, true, null);
                return new PerspectiveAwareBakedModel(faceQuads, generalQuads, TransformUtils.DEFAULT_BLOCK, modelProperties);
            }
            if (bakery instanceof ILayeredBlockBakery) {
                ILayeredBlockBakery layeredBakery = (ILayeredBlockBakery)bakery;
                HashMap<BlockRenderLayer, Map<Direction, List<BakedQuad>>> layerFaceQuadMap = new HashMap<BlockRenderLayer, Map<Direction, List<BakedQuad>>>();
                HashMap<BlockRenderLayer, List<BakedQuad>> layerGeneralQuads = new HashMap<BlockRenderLayer, List<BakedQuad>>();
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!state.func_177230_c().canRenderInLayer(state, layer)) continue;
                    LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                    quads.addAll(layeredBakery.bakeLayerFace(null, layer, state, data));
                    layerGeneralQuads.put(layer, quads);
                }
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    if (!state.func_177230_c().canRenderInLayer(state, layer)) continue;
                    HashMap faceQuadMap = new HashMap();
                    for (Direction face : Direction.field_82609_l) {
                        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
                        quads.addAll(layeredBakery.bakeLayerFace(face, layer, state, data));
                        faceQuadMap.put(face, quads);
                    }
                    layerFaceQuadMap.put(layer, faceQuadMap);
                }
                ModelProperties modelProperties = new ModelProperties(true, true, null);
                return new PerspectiveAwareLayeredModel(layerFaceQuadMap, layerGeneralQuads, new ModelProperties.PerspectiveProperties(TransformUtils.DEFAULT_BLOCK, modelProperties), BlockRenderLayer.SOLID);
            }
        }
        return missingModel;
    }

    private static <T, R> R timeModelGeneration(Function<T, R> func, T thing, String logPostfix) {
        if (DEBUG) {
            logger.info("Baking Model.. Key: {}", (Object)logPostfix);
        }
        long start = System.nanoTime();
        R ret = func.apply(thing);
        long end = System.nanoTime();
        ModelBakery.logGenTime(start, end);
        return ret;
    }

    private static <T, U, R> R timeModelGeneration(BiFunction<T, U, R> func, T thing, U thing2, String logPostfix) {
        if (DEBUG) {
            logger.info("Baking Model.. Key: {}", (Object)logPostfix);
        }
        long start = System.nanoTime();
        R ret = func.apply(thing, thing2);
        long end = System.nanoTime();
        ModelBakery.logGenTime(start, end);
        return ret;
    }

    private static void logGenTime(long start, long end) {
        if (DEBUG) {
            long delta = end - start;
            long millis = TimeUnit.NANOSECONDS.toMillis(delta);
            String s = millis >= 5L ? millis + "ms" : delta + "ns";
            logger.info("Baking finished in {}.", (Object)s);
        }
    }

    public static void nukeModelCache() {
        keyModelCache.invalidateAll();
    }

    static {
        defaultBlockKeyGenerator = (state, data) -> state.toString();
        defaultItemKeyGenerator = stack -> stack.func_77973_b().getRegistryName().toString() + "|" + stack.func_77952_i();
    }
}

