/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class RenderUtils {
    private static Vector3[] vectors = new Vector3[8];
    private static ItemRenderer uniformRenderItem;
    private static boolean hasInitRenderItem;
    private static ThreadLocal<IconTransformation> iconTransformCache;
    private static ItemEntity entityItem;

    private static void loadItemRenderer() {
        if (!hasInitRenderItem) {
            Minecraft minecraft = Minecraft.func_71410_x();
            uniformRenderItem = new ItemRenderer(minecraft.func_175598_ae(), minecraft.func_175599_af());
            hasInitRenderItem = true;
        }
    }

    public static void renderFluidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, TextureAtlasSprite icon, double res) {
        RenderUtils.renderFluidQuad(point2, vectors[0].set(point4).subtract(point1), vectors[1].set(point1).subtract(point2), icon, res);
    }

    public static void renderFluidQuad(Vector3 base, Vector3 wide, Vector3 high, TextureAtlasSprite icon, double res) {
        double rx;
        BufferBuilder r = CCRenderState.instance().getBuffer();
        double u1 = icon.func_94209_e();
        double du = icon.func_94212_f() - icon.func_94209_e();
        double v2 = icon.func_94210_h();
        double dv = icon.func_94210_h() - icon.func_94206_g();
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y + ry) / hlen);
                r.func_181662_b(base.x + dx1.x + dy2.x, base.y + dx1.y + dy2.y, base.z + dx1.z + dy2.z).func_187315_a(u1, v2 - ry / res * dv).func_181675_d();
                r.func_181662_b(base.x + dx1.x + dy1.x, base.y + dx1.y + dy1.y, base.z + dx1.z + dy1.z).func_187315_a(u1, v2).func_181675_d();
                r.func_181662_b(base.x + dx2.x + dy1.x, base.y + dx2.y + dy1.y, base.z + dx2.z + dy1.z).func_187315_a(u1 + rx / res * du, v2).func_181675_d();
                r.func_181662_b(base.x + dx2.x + dy2.x, base.y + dx2.y + dy2.y, base.z + dx2.z + dy2.z).func_187315_a(u1 + rx / res * du, v2 - ry / res * dv).func_181675_d();
            }
        }
    }

    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GlStateManager.translated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawCuboidOutline(Cuboid6 c) {
        CCRenderState state = CCRenderState.instance();
        BufferBuilder r = state.startDrawing(3, DefaultVertexFormats.field_181705_e);
        r.func_181662_b(c.min.x, c.min.y, c.min.z).func_181675_d();
        r.func_181662_b(c.max.x, c.min.y, c.min.z).func_181675_d();
        r.func_181662_b(c.max.x, c.min.y, c.max.z).func_181675_d();
        r.func_181662_b(c.min.x, c.min.y, c.max.z).func_181675_d();
        r.func_181662_b(c.min.x, c.min.y, c.min.z).func_181675_d();
        state.draw();
        state.startDrawing(3, DefaultVertexFormats.field_181705_e);
        r.func_181662_b(c.min.x, c.max.y, c.min.z).func_181675_d();
        r.func_181662_b(c.max.x, c.max.y, c.min.z).func_181675_d();
        r.func_181662_b(c.max.x, c.max.y, c.max.z).func_181675_d();
        r.func_181662_b(c.min.x, c.max.y, c.max.z).func_181675_d();
        r.func_181662_b(c.min.x, c.max.y, c.min.z).func_181675_d();
        state.draw();
        state.startDrawing(1, DefaultVertexFormats.field_181705_e);
        r.func_181662_b(c.min.x, c.min.y, c.min.z).func_181675_d();
        r.func_181662_b(c.min.x, c.max.y, c.min.z).func_181675_d();
        r.func_181662_b(c.max.x, c.min.y, c.min.z).func_181675_d();
        r.func_181662_b(c.max.x, c.max.y, c.min.z).func_181675_d();
        r.func_181662_b(c.max.x, c.min.y, c.max.z).func_181675_d();
        r.func_181662_b(c.max.x, c.max.y, c.max.z).func_181675_d();
        r.func_181662_b(c.min.x, c.min.y, c.max.z).func_181675_d();
        r.func_181662_b(c.min.x, c.max.y, c.max.z).func_181675_d();
        state.draw();
    }

    public static void drawCuboidSolid(Cuboid6 c) {
        CCRenderState ccrs = CCRenderState.instance();
        BufferBuilder buffer = ccrs.startDrawing(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(c.min.x, c.max.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.max.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.min.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.min.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.min.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.min.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.max.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.max.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.min.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.min.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.min.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.min.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.max.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.max.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.max.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.max.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.min.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.max.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.max.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.min.x, c.min.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.min.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.max.y, c.min.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.max.y, c.max.z).func_181675_d();
        buffer.func_181662_b(c.max.x, c.min.y, c.max.z).func_181675_d();
        ccrs.draw();
    }

    public static void renderFluidCuboid(Cuboid6 bound, TextureAtlasSprite tex, double res) {
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y - 0.009, (double)y + 1.009, (double)z - 0.009, (double)z + 1.009};
        BufferBuilder r = CCRenderState.instance().getBuffer();
        switch (side) {
            case 0: {
                r.func_181662_b(points[0], points[2], points[4]).func_187315_a(tx1, ty1).func_181675_d();
                r.func_181662_b(points[1], points[2], points[4]).func_187315_a(tx2, ty1).func_181675_d();
                r.func_181662_b(points[1], points[2], points[5]).func_187315_a(tx2, ty2).func_181675_d();
                r.func_181662_b(points[0], points[2], points[5]).func_187315_a(tx1, ty2).func_181675_d();
                break;
            }
            case 1: {
                r.func_181662_b(points[1], points[3], points[4]).func_187315_a(tx2, ty1).func_181675_d();
                r.func_181662_b(points[0], points[3], points[4]).func_187315_a(tx1, ty1).func_181675_d();
                r.func_181662_b(points[0], points[3], points[5]).func_187315_a(tx1, ty2).func_181675_d();
                r.func_181662_b(points[1], points[3], points[5]).func_187315_a(tx2, ty2).func_181675_d();
                break;
            }
            case 2: {
                r.func_181662_b(points[0], points[3], points[4]).func_187315_a(tx2, ty1).func_181675_d();
                r.func_181662_b(points[1], points[3], points[4]).func_187315_a(tx1, ty1).func_181675_d();
                r.func_181662_b(points[1], points[2], points[4]).func_187315_a(tx1, ty2).func_181675_d();
                r.func_181662_b(points[0], points[2], points[4]).func_187315_a(tx2, ty2).func_181675_d();
                break;
            }
            case 3: {
                r.func_181662_b(points[1], points[3], points[5]).func_187315_a(tx2, ty1).func_181675_d();
                r.func_181662_b(points[0], points[3], points[5]).func_187315_a(tx1, ty1).func_181675_d();
                r.func_181662_b(points[0], points[2], points[5]).func_187315_a(tx1, ty2).func_181675_d();
                r.func_181662_b(points[1], points[2], points[5]).func_187315_a(tx2, ty2).func_181675_d();
                break;
            }
            case 4: {
                r.func_181662_b(points[0], points[3], points[5]).func_187315_a(tx2, ty1).func_181675_d();
                r.func_181662_b(points[0], points[3], points[4]).func_187315_a(tx1, ty1).func_181675_d();
                r.func_181662_b(points[0], points[2], points[4]).func_187315_a(tx1, ty2).func_181675_d();
                r.func_181662_b(points[0], points[2], points[5]).func_187315_a(tx2, ty2).func_181675_d();
                break;
            }
            case 5: {
                r.func_181662_b(points[1], points[3], points[4]).func_187315_a(tx2, ty1).func_181675_d();
                r.func_181662_b(points[1], points[3], points[5]).func_187315_a(tx1, ty1).func_181675_d();
                r.func_181662_b(points[1], points[2], points[5]).func_187315_a(tx1, ty2).func_181675_d();
                r.func_181662_b(points[1], points[2], points[4]).func_187315_a(tx2, ty2).func_181675_d();
            }
        }
    }

    public static void renderHitBox(ActiveRenderInfo renderInfo, Cuboid6 cuboid) {
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.lineWidth((float)2.0f);
        GlStateManager.disableTexture();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        RenderUtils.drawCuboidOutline(cuboid.copy().expand(0.002f).subtract(renderInfo.func_216785_c()));
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    public static boolean shouldRenderFluid(FluidStack stack) {
        return stack.getAmount() > 0 && stack.getFluid() != null;
    }

    public static TextureAtlasSprite prepareFluidRender(FluidStack stack, int alpha) {
        Fluid fluid = stack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        CCRenderState.instance().colour = attributes.getColor(stack) << 8 | alpha;
        return TextureUtils.getTexture(attributes.getStill(stack));
    }

    public static void preFluidRender() {
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        TextureUtils.bindBlockTexture();
    }

    public static void postFluidRender() {
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
    }

    public static double fluidDensityToAlpha(double density) {
        return Math.pow(density, 0.4);
    }

    public static void renderFluidCuboid(FluidStack stack, Cuboid6 bound, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().getAttributes().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * density;
        }
        RenderUtils.renderFluidCuboid(bound, RenderUtils.prepareFluidRender(stack, alpha), res);
    }

    public static void renderFluidCuboidGL(FluidStack stack, Cuboid6 bound, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        RenderUtils.preFluidRender();
        CCRenderState state = CCRenderState.instance();
        state.startDrawing(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.renderFluidCuboid(stack, bound, density, res);
        state.pushColour();
        state.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidGauge(FluidStack stack, Rectangle4i rect, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().getAttributes().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            int height = (int)((double)rect.h * density);
            rect.y += rect.h - height;
            rect.h = height;
        }
        RenderUtils.renderFluidQuad(new Vector3(rect.x, rect.y + rect.h, 0.0), new Vector3(rect.w, 0.0, 0.0), new Vector3(0.0, -rect.h, 0.0), RenderUtils.prepareFluidRender(stack, alpha), res);
    }

    public static void renderFluidGaugeGL(FluidStack stack, Rectangle4i rect, double density, double res) {
        if (!RenderUtils.shouldRenderFluid(stack)) {
            return;
        }
        RenderUtils.preFluidRender();
        CCRenderState state = CCRenderState.instance();
        state.startDrawing(7, DefaultVertexFormats.field_181707_g);
        RenderUtils.renderFluidGauge(stack, rect, density, res);
        state.pushColour();
        state.draw();
        RenderUtils.postFluidRender();
    }

    public static Matrix4 getMatrix(Vector3 position, Rotation rotation, double scale) {
        return new Matrix4().translate(position).apply(new Scale(scale)).apply(rotation);
    }

    public static void renderItemUniform(ItemStack item) {
        RenderUtils.renderItemUniform(item, 0.0);
    }

    public static void renderItemUniform(ItemStack item, double spin) {
        RenderUtils.loadItemRenderer();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.func_92058_a(item);
        uniformRenderItem.func_76986_a(entityItem, 0.0, 0.06, 0.0, 0.0f, (float)(spin * 9.0 / Math.PI));
    }

    public static float getPearlBob(double time) {
        return (float)Math.sin(time / 25.0 * 3.141593) * 0.1f;
    }

    public static int getTimeOffset(BlockPos pos) {
        return RenderUtils.getTimeOffset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static int getTimeOffset(int x, int y, int z) {
        return x * 3 + y * 5 + z * 9;
    }

    public static IconTransformation getIconTransformation(TextureAtlasSprite sprite) {
        IconTransformation transformation = iconTransformCache.get();
        transformation.icon = sprite;
        return transformation;
    }

    static {
        iconTransformCache = ThreadLocal.withInitial(() -> new IconTransformation(TextureUtils.getBlockTexture("stone")));
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
        entityItem = new ItemEntity(EntityType.field_200765_E, null);
        RenderUtils.entityItem.field_70290_d = 0.0f;
    }
}

