/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.internal.ExceptionMessageEventHandler;
import codechicken.lib.internal.proxy.ProxyClient;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareBakedModel;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.util.LambdaUtils;
import codechicken.lib.util.TransformUtils;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCBlockRendererDispatcher
extends BlockRendererDispatcher {
    private static final Logger logger = LogManager.getLogger();
    public final BlockRendererDispatcher parentDispatcher;
    private static long lastTime;

    public CCBlockRendererDispatcher(BlockRendererDispatcher parent, BlockColors blockColours) {
        super(parent.func_175023_a(), blockColours);
        this.parentDispatcher = parent;
        this.field_175027_c = parent.field_175027_c;
        this.field_175025_e = parent.field_175025_e;
        this.field_175028_a = parent.field_175028_a;
    }

    public void func_215329_a(BlockState state, BlockPos pos, TextureAtlasSprite sprite, IEnviromentBlockReader world) {
        Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandle(world, pos, state)).findFirst();
        if (renderOpt.isPresent()) {
            ICCBlockRenderer renderer = renderOpt.get();
            BufferBuilder parent = Tessellator.func_178181_a().func_178180_c();
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_178969_c(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
            buffer.func_181668_a(7, parent.func_178973_g());
            renderer.handleRenderBlockDamage(world, pos, state, sprite, buffer);
            buffer.func_178977_d();
            buffer.func_178969_c(0.0, 0.0, 0.0);
            PerspectiveAwareBakedModel model = new PerspectiveAwareBakedModel(buffer.bake(), (IModelState)TransformUtils.DEFAULT_BLOCK, new ModelProperties(true, true, null));
            this.field_175027_c.func_217631_a(world, (IBakedModel)model, state, pos, parent, true, new Random(), state.func_209533_a(pos));
        } else {
            this.parentDispatcher.func_215329_a(state, pos, sprite, world);
        }
    }

    public boolean renderBlock(BlockState state, BlockPos pos, IEnviromentBlockReader world, BufferBuilder buffer, Random random, IModelData modelData) {
        BlockState inState = state;
        try {
            Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandle(world, pos, inState)).findFirst();
            if (renderOpt.isPresent()) {
                return renderOpt.get().renderBlock(world, pos, state, buffer, random, modelData);
            }
        }
        catch (Throwable t) {
            if (ProxyClient.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, inState, pos, world);
                return false;
            }
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)t, (String)"Tessellating CCL block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tessellated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashreport);
        }
        try {
            return this.parentDispatcher.renderBlock(state, pos, world, buffer, random, modelData);
        }
        catch (Throwable t) {
            if (ProxyClient.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, inState, pos, world);
                return false;
            }
            throw t;
        }
    }

    public boolean func_215331_a(BlockPos pos, IEnviromentBlockReader world, BufferBuilder buffer, IFluidState state) {
        Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandle(world, pos, state)).findFirst();
        if (renderOpt.isPresent()) {
            return renderOpt.get().renderFluid(world, pos, state, buffer);
        }
        return super.func_215331_a(pos, world, buffer, state);
    }

    public void func_175016_a(BlockState state, float brightness) {
        Optional<ICCBlockRenderer> renderOpt = BlockRenderingRegistry.getBlockRenderers().stream().filter(e -> e.canHandleBrightness(state)).findFirst();
        if (renderOpt.isPresent()) {
            renderOpt.get().renderBrightness(state, brightness);
        } else {
            this.parentDispatcher.func_175016_a(state, brightness);
        }
    }

    private static void handleCaughtException(Throwable t, BlockState inState, BlockPos pos, IEnviromentBlockReader world) {
        long time;
        Block inBlock = inState.func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        StringBuilder builder = new StringBuilder("\n CCL has caught an exception whilst rendering a block\n");
        builder.append("  BlockPos:      ").append(String.format("x:%s, y:%s, z:%s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).append("\n");
        builder.append("  Block Class:   ").append(LambdaUtils.tryOrNull(() -> inBlock.getClass())).append("\n");
        builder.append("  Registry Name: ").append(LambdaUtils.tryOrNull(() -> inBlock.getRegistryName())).append("\n");
        builder.append("  State:         ").append(inState).append("\n");
        builder.append(" Tile at position\n");
        builder.append("  Tile Class:    ").append(LambdaUtils.tryOrNull(() -> tile.getClass())).append("\n");
        builder.append("  Tile Id:       ").append(LambdaUtils.tryOrNull(() -> TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()))).append("\n");
        builder.append("  Tile NBT:      ").append(LambdaUtils.tryOrNull(() -> tile.func_189515_b(new CompoundNBT()))).append("\n");
        if (ProxyClient.messagePlayerOnRenderExceptionCaught) {
            builder.append("You can turn off player messages in the CCL config file.\n");
        }
        String logMessage = builder.toString();
        String key = ExceptionUtils.getStackTrace((Throwable)t) + logMessage;
        if (!ExceptionMessageEventHandler.exceptionMessageCache.contains(key)) {
            ExceptionMessageEventHandler.exceptionMessageCache.add(key);
            logger.error(logMessage, t);
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (ProxyClient.messagePlayerOnRenderExceptionCaught && player != null && TimeUnit.NANOSECONDS.toSeconds((time = System.nanoTime()) - lastTime) > 5L) {
            lastTime = time;
            player.func_145747_a((ITextComponent)new StringTextComponent("CCL Caught an exception rendering a block. See the log for info."));
        }
    }
}

