/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.math.MathHelper;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.VectorUtils;
import codechicken.lib.util.VertexDataUtils;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UV;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BakingVertexBuffer
extends BufferBuilder {
    private static final Logger logger = LogManager.getLogger();
    private HashMap<Integer, TextureAtlasSprite> spriteMap;
    private boolean useSprites = true;
    private boolean useDiffuseLighting = true;
    private static ThreadLocal<BakingVertexBuffer> threadBuffers = new ThreadLocal<BakingVertexBuffer>(){

        @Override
        protected BakingVertexBuffer initialValue() {
            return new BakingVertexBuffer(0x200000);
        }
    };

    public static BakingVertexBuffer create() {
        return threadBuffers.get();
    }

    private BakingVertexBuffer(int bufferSizeIn) {
        super(bufferSizeIn);
    }

    public void func_181668_a(int glMode, VertexFormat format) {
        if (glMode != 7) {
            throw new IllegalArgumentException("Unable to bake GL Mode, only Quads supported! To bake triangles pipe through CCQuad then quadulate.");
        }
        super.func_181668_a(glMode, format);
    }

    public void func_178965_a() {
        this.spriteMap = new HashMap();
        this.useSprites = true;
        this.useDiffuseLighting = true;
        super.func_178965_a();
    }

    public BakingVertexBuffer setSprite(TextureAtlasSprite sprite) {
        this.spriteMap.put(MathHelper.floor((double)this.func_178989_h() / 4.0), sprite);
        return this;
    }

    public BakingVertexBuffer ignoreSprites() {
        this.useSprites = false;
        return this;
    }

    public BakingVertexBuffer useSprites() {
        this.useSprites = true;
        return this;
    }

    public BakingVertexBuffer dissableDiffuseLighting() {
        this.useDiffuseLighting = false;
        return this;
    }

    public BakingVertexBuffer enableDiffuseLighting() {
        this.useDiffuseLighting = true;
        return this;
    }

    public List<BakedQuad> bake() {
        BufferBuilder.State state;
        VertexFormat format;
        if (this.field_179010_r) {
            logger.warn("Someone is calling bake before finishDrawing!", (Throwable)new IllegalStateException("Bake called before finishDrawing!"));
            this.func_178977_d();
        }
        if (!(format = (state = this.func_181672_a()).func_179016_d()).func_207750_a(0)) {
            throw new IllegalStateException("Unable to bake format that does not have UV mappings!");
        }
        int[] rawBuffer = Arrays.copyOf(state.func_179013_a(), state.func_179013_a().length);
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        TextureAtlasSprite sprite = TextureUtils.getMissingSprite();
        int curr = 0;
        int next = format.func_177338_f();
        int i = 0;
        while (rawBuffer.length >= next) {
            Direction facing;
            int[] quadData = Arrays.copyOfRange(rawBuffer, curr, next);
            Vector3 normal = new Vector3();
            if (format.func_207751_b()) {
                float[] normalData = new float[4];
                LightUtil.unpack((int[])quadData, (float[])normalData, (VertexFormat)format, (int)0, (int)VertexDataUtils.getNormalElement(format));
                normal = Vector3.fromArray(normalData);
            } else {
                float[][] posData = new float[4][4];
                for (int v = 0; v < 4; ++v) {
                    LightUtil.unpack((int[])quadData, (float[])posData[v], (VertexFormat)format, (int)v, (int)VertexDataUtils.getPositionElement(format));
                }
                normal.set(VectorUtils.calculateNormal(Vector3.fromArray(posData[0]), Vector3.fromArray(posData[1]), Vector3.fromArray(posData[3])));
            }
            if (this.useSprites) {
                if (this.spriteMap.containsKey(i)) {
                    sprite = this.spriteMap.get(i);
                } else {
                    float[] uvData = new float[4];
                    LightUtil.unpack((int[])quadData, (float[])uvData, (VertexFormat)format, (int)0, (int)VertexDataUtils.getUVElement(format));
                    UV uv = new UV(uvData[0], uvData[1]);
                    sprite = VertexDataUtils.getSpriteForUV(TextureUtils.getTextureMap(), uv);
                }
            }
            if ((facing = VectorUtils.calcNormalSide(normal)) == null) {
                facing = Direction.UP;
            }
            BakedQuad quad = new BakedQuad(quadData, -1, facing, sprite, this.useDiffuseLighting, format);
            quads.add(quad);
            curr = next;
            next += format.func_177338_f();
            ++i;
        }
        return ImmutableList.copyOf(quads);
    }
}

