/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.lighting;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.PlanarLightModel;
import codechicken.lib.render.pipeline.IVertexOperation;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;

public class PlanarLightMatrix
extends PlanarLightModel {
    public static final int operationIndex = IVertexOperation.registerOperation();
    public static PlanarLightMatrix instance = new PlanarLightMatrix();
    public IEnviromentBlockReader access;
    public BlockPos pos = BlockPos.field_177992_a;
    private int sampled = 0;
    public int[] brightness = new int[6];

    public PlanarLightMatrix() {
        super(PlanarLightModel.standardLightModel.colours);
    }

    public PlanarLightMatrix locate(IEnviromentBlockReader a, BlockPos bPos) {
        this.access = a;
        this.pos = bPos;
        this.sampled = 0;
        return this;
    }

    public int brightness(int side) {
        if ((this.sampled & 1 << side) == 0) {
            BlockState b = this.access.func_180495_p(this.pos);
            this.brightness[side] = this.access.func_217338_b(this.pos, b.func_177230_c().getLightValue(b, this.access, this.pos));
            this.sampled |= 1 << side;
        }
        return this.brightness[side];
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        ccrs.pipeline.addDependency(ccrs.sideAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        super.operate(ccrs);
        ccrs.brightness = this.brightness(ccrs.side);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

