/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.particle;

import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.particle.CustomBreakingParticle;
import codechicken.lib.render.particle.IModelParticleProvider;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class CustomParticleHandler {
    public static boolean handleLandingEffects(ServerWorld world, BlockPos pos, LivingEntity entity, int numParticles) {
        PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 1);
        packet.writePos(pos);
        packet.writeVector(Vector3.fromEntity((Entity)entity));
        packet.writeVarInt(numParticles);
        packet.sendToPlayer((ServerPlayerEntity)entity);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleRunningEffects(World world, BlockPos pos, BlockState state, Entity entity) {
        BlockRayTraceResult traceResult = new BlockRayTraceResult(entity.func_213303_ch().func_72441_c(0.0, 1.0, 0.0), Direction.UP, pos, false);
        BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        IBakedModel model = modelShapes.func_178125_b(state);
        if (model instanceof IModelParticleProvider) {
            IModelData modelData = ModelDataManager.getModelData((World)world, (BlockPos)pos);
            ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getHitEffects(traceResult, state, (IEnviromentBlockReader)world, pos, modelData));
            TextureAtlasSprite rolledSprite = (TextureAtlasSprite)sprites.get(world.field_73012_v.nextInt(sprites.size()));
            double x = entity.field_70165_t + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf();
            double y = entity.func_174813_aQ().field_72338_b + 0.1;
            double z = entity.field_70161_v + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf();
            particleManager.func_78873_a((Particle)new CustomBreakingParticle(world, x, y, z, -entity.func_213322_ci().field_72450_a * 4.0, 1.5, -entity.func_213322_ci().field_72449_c * 4.0, rolledSprite));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleHitEffects(BlockState state, World world, RayTraceResult traceResult, ParticleManager manager) {
        if (traceResult instanceof BlockRayTraceResult) {
            BlockRayTraceResult hit = (BlockRayTraceResult)traceResult;
            BlockPos pos = hit.func_216350_a();
            BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
            IBakedModel model = modelShapes.func_178125_b(state);
            if (model instanceof IModelParticleProvider) {
                IModelData modelData = ModelDataManager.getModelData((World)world, (BlockPos)pos);
                Cuboid6 bounds = hit instanceof CuboidRayTraceResult ? ((CuboidRayTraceResult)hit).cuboid6 : new Cuboid6(state.func_196954_c((IBlockReader)world, pos).func_197752_a());
                bounds = ((Cuboid6)bounds).copy().add(pos);
                Set<TextureAtlasSprite> hitSprites = ((IModelParticleProvider)model).getHitEffects(hit, state, (IEnviromentBlockReader)world, pos, modelData);
                ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(hitSprites);
                CustomParticleHandler.addBlockHitEffects(world, bounds, hit.func_216354_b(), (TextureAtlasSprite)sprites.get(world.field_73012_v.nextInt(sprites.size())), manager);
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleDestroyEffects(World world, BlockPos pos, BlockState state, ParticleManager manager) {
        BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        IBakedModel model = modelShapes.func_178125_b(state);
        if (model instanceof IModelParticleProvider) {
            IModelData modelData = ModelDataManager.getModelData((World)world, (BlockPos)pos);
            Cuboid6 bounds = new Cuboid6(state.func_196954_c((IBlockReader)world, pos).func_197752_a());
            CustomParticleHandler.addBlockDestroyEffects(world, bounds.add(pos), new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getDestroyEffects(state, (IEnviromentBlockReader)world, pos, modelData)), manager);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addLandingEffects(World world, BlockPos pos, BlockState state, Vector3 entityPos, int numParticles) {
        BlockRayTraceResult traceResult = new BlockRayTraceResult(new Vec3d(entityPos.x, (double)(pos.func_177956_o() + 1), entityPos.z), Direction.UP, pos, false);
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        Random randy = new Random();
        BlockModelShapes modelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        IBakedModel model = modelShapes.func_178125_b(state);
        if (model instanceof IModelParticleProvider) {
            IModelData modelData = ModelDataManager.getModelData((World)world, (BlockPos)pos);
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getHitEffects(traceResult, state, (IEnviromentBlockReader)world, pos, modelData));
            double speed = 0.15f;
            if (numParticles != 0) {
                for (int i = 0; i < numParticles; ++i) {
                    double mX = randy.nextGaussian() * speed;
                    double mY = randy.nextGaussian() * speed;
                    double mZ = randy.nextGaussian() * speed;
                    manager.func_78873_a((Particle)CustomBreakingParticle.newLandingParticle(world, entityPos.x, entityPos.y, entityPos.z, mX, mY, mZ, (TextureAtlasSprite)sprites.get(randy.nextInt(sprites.size()))));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBlockHitEffects(World world, Cuboid6 bounds, Direction side, TextureAtlasSprite icon, ParticleManager particleManager) {
        float border = 0.1f;
        Vector3 diff = bounds.max.copy().subtract(bounds.min).add(-2.0f * border);
        diff.x *= world.field_73012_v.nextDouble();
        diff.y *= world.field_73012_v.nextDouble();
        diff.z *= world.field_73012_v.nextDouble();
        Vector3 pos = diff.add(bounds.min).add(border);
        if (side == Direction.DOWN) {
            diff.y = bounds.min.y - (double)border;
        }
        if (side == Direction.UP) {
            diff.y = bounds.max.y + (double)border;
        }
        if (side == Direction.NORTH) {
            diff.z = bounds.min.z - (double)border;
        }
        if (side == Direction.SOUTH) {
            diff.z = bounds.max.z + (double)border;
        }
        if (side == Direction.WEST) {
            diff.x = bounds.min.x - (double)border;
        }
        if (side == Direction.EAST) {
            diff.x = bounds.max.x + (double)border;
        }
        particleManager.func_78873_a(new CustomBreakingParticle(world, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, icon).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBlockDestroyEffects(World world, Cuboid6 bounds, List<TextureAtlasSprite> icons, ParticleManager particleManager) {
        Vector3 diff = bounds.max.copy().subtract(bounds.min);
        Vector3 center = bounds.min.copy().add(bounds.max).multiply(0.5);
        Vector3 density = diff.copy().multiply(4.0).ceil();
        int i = 0;
        while ((double)i < density.x) {
            int j = 0;
            while ((double)j < density.y) {
                int k = 0;
                while ((double)k < density.z) {
                    double x = bounds.min.x + ((double)i + 0.5) * diff.x / density.x;
                    double y = bounds.min.y + ((double)j + 0.5) * diff.y / density.y;
                    double z = bounds.min.z + ((double)k + 0.5) * diff.z / density.z;
                    particleManager.func_78873_a((Particle)new CustomBreakingParticle(world, x, y, z, x - center.x, y - center.y, z - center.z, icons.get(world.field_73012_v.nextInt(icons.size()))));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

