/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.texture;

import codechicken.lib.texture.AtlasRegistrar;
import codechicken.lib.texture.IIconRegister;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class SpriteRegistryHelper {
    public static final String TEXTURES = "textures";
    public static final String PARTICLE_TEXTURES = "textures/particle";
    public static final String MOB_EFFECT_TEXTURES = "textures/mob_effect";
    public static final String PAINTING_TEXTURES = "textures/painting";
    private final Multimap<String, IIconRegister> iconRegisters = HashMultimap.create();
    private final Map<String, AtlasRegistrarImpl> atlasRegistrars = new HashMap<String, AtlasRegistrarImpl>();

    public SpriteRegistryHelper() {
        this(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public SpriteRegistryHelper(IEventBus eventBus) {
        eventBus.register((Object)this);
    }

    public void addIIconRegister(String basePath, IIconRegister iconRegister) {
        this.iconRegisters.put((Object)basePath, (Object)iconRegister);
    }

    public void addIIconRegister(IIconRegister iconRegister) {
        this.addIIconRegister(TEXTURES, iconRegister);
    }

    private AtlasRegistrarImpl getRegistrar(AtlasTexture atlas) {
        AtlasRegistrarImpl registrar = this.atlasRegistrars.get(atlas.getBasePath());
        if (registrar == null) {
            registrar = new AtlasRegistrarImpl();
            this.atlasRegistrars.put(atlas.getBasePath(), registrar);
        }
        return registrar;
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        AtlasTexture atlas = event.getMap();
        AtlasRegistrarImpl registrar = this.getRegistrar(atlas);
        this.iconRegisters.get((Object)atlas.getBasePath()).forEach(e -> e.registerIcons(registrar));
        registrar.processPre(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        AtlasTexture atlas = event.getMap();
        AtlasRegistrarImpl registrar = this.getRegistrar(atlas);
        registrar.processPost(atlas);
    }

    private static final class AtlasRegistrarImpl
    implements AtlasRegistrar {
        private final Multimap<ResourceLocation, Consumer<TextureAtlasSprite>> sprites = HashMultimap.create();
        private final List<Consumer<AtlasTexture>> postCallbacks = new ArrayList<Consumer<AtlasTexture>>();

        private AtlasRegistrarImpl() {
        }

        @Override
        public void registerSprite(ResourceLocation loc, Consumer<TextureAtlasSprite> onReady) {
            this.sprites.put((Object)loc, onReady);
        }

        @Override
        public void postRegister(Consumer<AtlasTexture> func) {
            this.postCallbacks.add(func);
        }

        private void processPre(Consumer<ResourceLocation> register) {
            this.sprites.keySet().forEach(register);
        }

        private void processPost(AtlasTexture atlas) {
            for (Map.Entry entry : this.sprites.asMap().entrySet()) {
                TextureAtlasSprite sprite = atlas.func_195424_a((ResourceLocation)entry.getKey());
                ((Collection)entry.getValue()).forEach(e -> e.accept(sprite));
            }
            for (Consumer consumer : this.postCallbacks) {
                consumer.accept(atlas);
            }
        }
    }
}

