/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.texture;

import codechicken.lib.util.ResourceUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    public static BufferedImage loadBufferedImage(ResourceLocation textureFile) {
        try {
            return TextureUtils.loadBufferedImage(ResourceUtils.getResourceAsStream(textureFile));
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GlStateManager.texParameter((int)target, (int)10241, (int)min_mag_filter);
        GlStateManager.texParameter((int)target, (int)10240, (int)min_mag_filter);
        if (target == 3553) {
            GlStateManager.bindTexture((int)target);
        } else {
            GL11.glBindTexture((int)target, (int)texture);
        }
        switch (target) {
            case 32879: {
                GlStateManager.texParameter((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GlStateManager.texParameter((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GlStateManager.texParameter((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static TextureManager getTextureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public static AtlasTexture getTextureMap() {
        return Minecraft.func_71410_x().func_147117_R();
    }

    public static TextureAtlasSprite getMissingSprite() {
        return TextureUtils.getTextureMap().func_195424_a(MissingTextureSprite.func_195675_b());
    }

    public static TextureAtlasSprite getTexture(String location) {
        return TextureUtils.getTextureMap().func_110572_b(location);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return TextureUtils.getTexture(location.toString());
    }

    public static TextureAtlasSprite getBlockTexture(String string) {
        return TextureUtils.getBlockTexture(new ResourceLocation(string));
    }

    public static TextureAtlasSprite getBlockTexture(ResourceLocation location) {
        return TextureUtils.getTexture(new ResourceLocation(location.func_110624_b(), "block/" + location.func_110623_a()));
    }

    public static TextureAtlasSprite getItemTexture(String string) {
        return TextureUtils.getItemTexture(new ResourceLocation(string));
    }

    public static TextureAtlasSprite getItemTexture(ResourceLocation location) {
        return TextureUtils.getTexture(new ResourceLocation(location.func_110624_b(), "items/" + location.func_110623_a()));
    }

    public static void changeTexture(String texture) {
        TextureUtils.changeTexture(new ResourceLocation(texture));
    }

    public static void changeTexture(ResourceLocation texture) {
        TextureUtils.getTextureManager().func_110577_a(texture);
    }

    public static void disableMipmap(String texture) {
        TextureUtils.disableMipmap(new ResourceLocation(texture));
    }

    public static void disableMipmap(ResourceLocation texture) {
        TextureUtils.getTextureManager().func_110581_b(texture).func_174936_b(false, false);
    }

    public static void restoreLastMipmap(String texture) {
        TextureUtils.restoreLastMipmap(new ResourceLocation(texture));
    }

    public static void restoreLastMipmap(ResourceLocation location) {
        TextureUtils.getTextureManager().func_110581_b(location).func_174935_a();
    }

    public static void bindBlockTexture() {
        TextureUtils.changeTexture(AtlasTexture.field_110575_b);
    }

    public static void dissableBlockMipmap() {
        TextureUtils.disableMipmap(AtlasTexture.field_110575_b);
    }

    public static void restoreBlockMipmap() {
        TextureUtils.restoreLastMipmap(AtlasTexture.field_110575_b);
    }

    @Deprecated
    public static TextureAtlasSprite[] getSideIconsForBlock(BlockState state) {
        TextureAtlasSprite[] sideSprites = new TextureAtlasSprite[6];
        TextureAtlasSprite missingSprite = TextureUtils.getMissingSprite();
        for (int i = 0; i < 6; ++i) {
            TextureAtlasSprite[] sprites = TextureUtils.getIconsForBlock(state, i);
            TextureAtlasSprite sideSprite = missingSprite;
            if (sprites.length != 0) {
                sideSprite = sprites[0];
            }
            sideSprites[i] = sideSprite;
        }
        return sideSprites;
    }

    @Deprecated
    public static TextureAtlasSprite[] getIconsForBlock(BlockState state, int side) {
        return TextureUtils.getIconsForBlock(state, Direction.values()[side]);
    }

    @Deprecated
    public static TextureAtlasSprite[] getIconsForBlock(BlockState state, Direction side) {
        List quads;
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model != null && (quads = model.func_200117_a(state, side, new Random(0L))) != null && quads.size() > 0) {
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[quads.size()];
            for (int i = 0; i < quads.size(); ++i) {
                sprites[i] = ((BakedQuad)quads.get(i)).func_187508_a();
            }
            return sprites;
        }
        return new TextureAtlasSprite[0];
    }

    @Deprecated
    public static TextureAtlasSprite getParticleIconForBlock(BlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model != null) {
            return model.func_177554_e();
        }
        return null;
    }
}

